﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.DAL.OleDB
{
    [Serializable]
    public class WebMenu : KstCMS.DAL.IWebMenu
    {
       public void Add(string[] FieldValues, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataInsert("WebMenu", FieldValues, FieldNames);
        }

        public void Delete(int id)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from WebMenu where MenuID=@id");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
                    new System.Data.OleDb.OleDbParameter("@id",System.Data.OleDb.OleDbType.Integer)};
            cmdParms[0].Value = id;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }

        public void Update(string[] FieldValues, int IndexId, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataUpdate("WebMenu", "MenuID", IndexId.ToString(), FieldValues, FieldNames);
        }

        public KstCMS.Model.SiteModel.WebMenu GetModel(int id, params string[] FieldNames)
        {
            KstCMS.Model.SiteModel.WebMenu Model = new Model.SiteModel.WebMenu();
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldNames));
            sb.Append(" from WebMenu where MenuID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = id;
            System.Data.DataSet dsData = KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString(), cmdParms);
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string Field = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], Field, ref Model);
                }
            }
            return Model;
        }

        public System.Data.DataSet GetList(string strWhere, string OrderBy, int Top, params string[] FieldNames)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(Top, FieldNames));
            sb.Append(" from WebMenu");
            if (!string.IsNullOrEmpty(strWhere))
            {
                sb.Append(" where " + strWhere);
            }
            if (!string.IsNullOrEmpty(OrderBy))
            {
                sb.Append(" order by " + OrderBy);
            }
            return KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString());
        }

        public bool Exists(int Id)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from WebMenu");
            sb.Append(" where MenuID=@id ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { new System.Data.OleDb.OleDbParameter("@id", System.Data.OleDb.OleDbType.Integer) };
            cmdParms[0].Value = Id;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }

        public bool Exists(int SiteId, string MenuDir)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from WebMenu");
            sb.Append(" where SiteID=@SiteId and MenuDiy=@MenuDiy ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { 
                 new System.Data.OleDb.OleDbParameter("@SiteId", System.Data.OleDb.OleDbType.Integer),
                 new System.Data.OleDb.OleDbParameter("@MenuDiy", System.Data.OleDb.OleDbType.VarChar,50)
             };
            cmdParms[0].Value = SiteId;
            cmdParms[1].Value = MenuDir;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }

        public int GetMaxId()
        {
            return KstSoft.DBUtility.OleDB_Helper.GetMaxID("MenuID", "WebMenu");
        }


        private void GetField(System.Data.DataRow Row, string FieldName, ref KstCMS.Model.SiteModel.WebMenu WebMenu)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "MenuID":
                    WebMenu.MenuID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteID":
                    WebMenu.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "MenuName":
                    WebMenu.MenuName = FieldValue;
                    break;
                case "MenuDiy":
                    WebMenu.MenuDir = FieldValue;
                    break;
                case "GoUrl":
                    WebMenu.GoUrl = FieldValue;
                    break;
                case "IsOutUrl":
                    WebMenu.IsOutUrl = Convert.ToInt32(FieldValue);
                    break;
                case "GoLmID":
                    WebMenu.GoLmID = Convert.ToInt32(FieldValue);
                    break;
                case "MateKey":
                    WebMenu.MetaKey = FieldValue;
                    break;
                case "MateDesc":
                    WebMenu.MetaDesc = FieldValue;
                    break;
                case "Act":
                    WebMenu.Act = Convert.ToInt32(FieldValue);
                    break;
                case "AttRib":
                    WebMenu.AttRib = Convert.ToInt32(FieldValue);
                    break;
                case "SortNo":
                    WebMenu.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "TempID":
                    WebMenu.TempID = Convert.ToInt32(FieldValue);
                    break;
                case "IsShow":
                    WebMenu.IsShow = Convert.ToInt32(FieldValue);
                    break;

            }
        }
    }
}
