﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;

namespace KstCMS.KstCMS_Manager
{
    public partial class Admin_login : KstCmsBase.WebPage.BasePage
    {

        protected void Page_Load(object sender, EventArgs e)
        {

            if (!IsPostBack)
            {

                this.Header.Title = base.ComName + "--" + base.WebTitle;
                Set_Validator();

            }
            ScriptManager1.AsyncPostBackError += new EventHandler<AsyncPostBackErrorEventArgs>(ScriptManager1_AsyncPostBackError);
            ImageButton1.Click += new ImageClickEventHandler(ImageButton1_Click);
        }

        void ImageButton1_Click(object sender, ImageClickEventArgs e)
        {
            System.Threading.Thread.Sleep(1000);
            String UserName = KstCmsBase.Common.Fucs.NoHTML(UserId.Text.Trim());
            String Pwd = FormsAuthentication.HashPasswordForStoringInConfigFile(KstCmsBase.Common.Fucs.NoHTML(UserPwd.Text.Trim()), "MD5");

            String ViteCode = Request.Form.Get("VateCode").Trim();
            if (ViteCode != (String)Session["Code"])
            {
                throw new Exception("验证码错误，请重新输入！");
            }
            if (KstCmsBase.DAL.Users.Chk_UserAct(UserName))
            {
                throw new Exception("用户被锁定，不能登录！");
            }
            if (KstCmsBase.DAL.Users.Login(UserName, Pwd))
            {
               
                FormsAuthentication.SetAuthCookie(UserName, false);
                FormsAuthentication.RedirectFromLoginPage(UserName, false);
                Hashtable hOnline = (Hashtable)Application["Online"];
                if (hOnline != null)
                {
                    IDictionaryEnumerator idE = hOnline.GetEnumerator();
                    //String LoginCookiec = Request.Cookies.Get("portalroles").Value;
                    string strKey = "";
                    while (idE.MoveNext())
                    {
                        if (idE.Value != null && idE.Value.ToString().Equals(UserName))
                        {
                            //already login             
                            strKey = idE.Key.ToString();
                            hOnline[strKey] = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";

                            // hOnline[strKey] = LoginCookiec;
                            break;
                        }
                    }
                }
                else
                {
                    hOnline = new Hashtable();
                }
                hOnline[Session.SessionID] = UserName;
                Application.Lock();
                Application["Online"] = hOnline;
                Application.UnLock();
                Response.Redirect("default.aspx");

            }
            else
            {
                throw new Exception("用户名或密码错误！");
            }
        }

        void ScriptManager1_AsyncPostBackError(object sender, AsyncPostBackErrorEventArgs e)
        {
            ScriptManager.GetCurrent(this).AsyncPostBackErrorMessage = e.Exception.Message;
        }



        private void Set_Validator()
        {
            if (!ClientScript.IsClientScriptIncludeRegistered(this.GetType(), "CheckForm"))
            {
                Page.ClientScript.RegisterClientScriptInclude("CheckForm", "JavaScript/CheckForm.js");

            }
            UserId.Attributes.Add("title", "用户名~!");
            ImageButton1.Attributes.Add("onclick", "return checkForm(this.form)");

        }
    }
}