﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.CreateWeb.Html
{
    public partial class Create_Index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            btnIndex.Click += new EventHandler(btnIndex_Click);
            btnMenu.Click += new EventHandler(btnMenu_Click);
            btnAll.Click += new EventHandler(btnAll_Click);
            btnMap.Click += new EventHandler(btnMap_Click);
            btnLink.Click += new EventHandler(btnLink_Click);
            btnXml.Click += new EventHandler(btnXml_Click);
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                ShowMenuList();
            }
        }

        void btnXml_Click(object sender, EventArgs e)
        {
            string Domain  = KstCmsBase.DAL.Regedit.Get_UnitInfo("URL").URL;
            KstWEB.SiteWeb.Create_SiteMapXML(Domain);
            ShowMsgModle("生成成功！");
        }

        void btnLink_Click(object sender, EventArgs e)
        {
            KstWEB.SiteWeb.CreateLinkPage(Convert.ToInt32(drp_SiteList.SelectedValue));
            ShowMsgModle("生成成功！");
        }

        void btnMap_Click(object sender, EventArgs e)
        {
            KstWEB.SiteWeb.CreateSiteMap(Convert.ToInt32(drp_SiteList.SelectedValue));
            ShowMsgModle("生成成功！");
        }

        void btnAll_Click(object sender, EventArgs e)
        {
            throw new NotImplementedException();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuList();
        }

        void btnIndex_Click(object sender, EventArgs e)
        {
            KstWEB.SiteWeb.CreateIndexPage(Convert.ToInt32(drp_SiteList.SelectedValue));
            ShowMsgModle("生成成功！");
        }

        void btnMenu_Click(object sender, EventArgs e)
        {  
            foreach (ListItem item in ListBox1.Items)
            {
                if (item.Selected)
                    KstWEB.SiteWeb.CreateMenuIndex(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(item.Value));
            }
            ShowMsgModle("生成成功！");
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }

        }

        void ShowMenuList()
        {
            ListBox1.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection MenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(drp_SiteList.SelectedValue), 1, "MenuID", "MenuName","IsOutUrl","GoLmID");
            foreach (KstCmsBase.Entities.WebMenu_ent Menu in MenuItems)
            {
                if (Menu.IsOutUrl != 1 && Menu.GoLmID == 0)
                {
                    ListItem item = new ListItem();
                    item.Value = Menu.MenuID.ToString();
                    item.Text = Menu.MenuName;
                    ListBox1.Items.Add(item);
                }
            }
            if (ListBox1.Items.Count < 1)
                btnMenu.Enabled = false;
            else
                btnMenu.Enabled = true;


        }

    }
}