﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.CreateWeb.Html
{
    public partial class Create_uPage : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            btnMenu.Click += new EventHandler(btnMenu_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                ShowMenuDrp();
                ShowLmList();
            }
        }

        void btnMenu_Click(object sender, EventArgs e)
        {
            foreach (ListItem item in ListBox1.Items)
            {
                if (item.Selected)
                    KstWEB.SiteWeb.CreateuPage(Convert.ToInt32(drp_SiteList.SelectedValue),Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(item.Value));
            }
            ShowMsgModle("生成成功！");
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowLmList();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp();
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
        }

        void ShowMenuDrp()
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenu = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(drp_SiteList.SelectedValue),1,0, "MenuID", "MenuName");
            foreach (KstCmsBase.Entities.WebMenu_ent Menu in WebMenu)
            {
                ListItem item = new ListItem();
                item.Value = Menu.MenuID.ToString();
                item.Text = Menu.MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择", "0"));
        }


        void ShowLmList()
        {
            ListBox1.Items.Clear();
            KstCmsBase.Collection.WebLmCollection LmITEMS =KstCmsBase.DAL.WebLM.Get_LMList(Convert.ToInt32(drp_MenuList.SelectedValue),"LmID","LmName");
            foreach (KstCmsBase.Entities.WebLm_ent Lm in LmITEMS)
            {

                    ListItem item = new ListItem();
                    item.Value = Lm.LmID.ToString();
                    item.Text = Lm.LmName;
                    ListBox1.Items.Add(item);

            }
            if (ListBox1.Items.Count < 1)
                btnMenu.Enabled = false;
            else
                btnMenu.Enabled = true;

        }
    }
}