﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Manager.Feeback.lb
{
    public partial class LbList : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            repMain.ItemDataBound += new RepeaterItemEventHandler(repMain_ItemDataBound);
            repMain.ItemCommand += new RepeaterCommandEventHandler(repMain_ItemCommand);
            if (!IsPostBack)
            {
                RepMain_Bind();
            }
        }

        void repMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            KstCmsBase.DAL.Feeback.Ly.Lylb_delete(Convert.ToInt32(e.CommandName.ToString()));
            RepMain_Bind();
        }

        void repMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                int isSys = ((KstCmsBase.Entities.Feeback.LyLbEnt)e.Item.DataItem).isSys;
                ((LinkButton)e.Item.FindControl("DelBtn")).Visible = isSys == 0;
            }
        }

        void RepMain_Bind()
        {
            KstCmsBase.Collection.Feeback.LyLbCollection LyLbitems = KstCmsBase.DAL.Feeback.Ly.Get_LyLBitems();
            repMain.DataSource = LyLbitems;
            repMain.DataBind();
        }
    }
}