﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Manager.Feeback.query
{
    public partial class RepFrm : KstCmsBase.WebPage.ValidationPage
    {
        string Lyid = System.Web.HttpContext.Current.Request.QueryString.Get("LyID");
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Get_info();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            try
            {
                KstCmsBase.DAL.EmlServer.Mailto("Reply:" + LyTitle.Value, RepContent.Value, System.Text.Encoding.UTF8, lit_Email.Text.Trim());
                KstCmsBase.DAL.Feeback.Ly.Rely(Convert.ToInt32(Lyid), RepContent.Value);
                ShowMsgModle("回复成功！", " $(pageInit);");
            }
            catch
            {
                throw new Exception("回复失败！");
            }
        }

        void Get_info()
        {
            KstCmsBase.Entities.Feeback.LyEnt Lyinfo = KstCmsBase.DAL.Feeback.Ly.Get_LyInfo(Convert.ToInt32(Lyid));
            lit_addr.Text = Lyinfo.Addr;
            lit_Attn.Text = Lyinfo.Attn;
            lit_Cname.Text = Lyinfo.CName;
            lit_Email.Text = Lyinfo.Email;
            lit_fax.Text = Lyinfo.Fax;
            lit_tel.Text = Lyinfo.Tel;
            ip.Text = Lyinfo.IP;
            string RepContentStr = Lyinfo.LyContent.Replace("\r\n", "<br />");
            RepContentStr = "<span style=\"color:red; font-size:16px\">您的问题：" + Lyinfo.LyTitle + ":</span><br><br><div style=\"border:1px solid #cccccc; padding:4px; line-height:25px\">" + RepContentStr + "</div>";
            RepContentStr += "<br /><br /><span style=\"color:red; font-size:16px\">回复内容:<span><br /><br />";
            if (!string.IsNullOrEmpty(Lyinfo.ReContent))
                RepContentStr = Lyinfo.ReContent;
            RepContent.Value = RepContentStr;
            LyTitle.Value = Lyinfo.LyTitle;
        }

    }
}