﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Manager.Link.lb
{
    public partial class LbList : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            repMain.ItemCommand += new RepeaterCommandEventHandler(repMain_ItemCommand);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            if (!IsPostBack)
            {
                RepMain_Bind();
            }
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string lbids = Request.Form.Get("chxbox");
            if (!string.IsNullOrEmpty(lbids))
            {
                string[] ids = lbids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                foreach (string id in ids)
                {
                    string SortNo = Request.Form.Get("SortNo_" + id);
                    string[] data = new string[] { SortNo };
                    KstCmsBase.DAL.Link.FLink.LinkLB_Update(Convert.ToInt32(id), data, "SortNo");
                }
            }
            RepMain_Bind();
        }

        void repMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            KstCmsBase.DAL.Link.FLink.LinkLB_delete(Convert.ToInt32(e.CommandName.ToString()));
            RepMain_Bind();
        }

        void RepMain_Bind()
        {
            repMain.DataSource = KstCmsBase.DAL.Link.FLink.Get_LinkLB_Items();
            repMain.DataBind();
        }

    }
}