﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.Manager.Link.query
{
    public partial class LinkList : KstCmsBase.WebPage.ValidationPage
    {
        string Act = System.Web.HttpContext.Current.Request.QueryString.Get("Act");
        protected void Page_Load(object sender, EventArgs e)
        {
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            drp_LbList.SelectedIndexChanged += new EventHandler(drp_LbList_SelectedIndexChanged);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                ShowMenuDrp(drp_SiteList.SelectedValue);
                ShowLBdrp();
                repMain_bind();
            }
        }

        void drp_LbList_SelectedIndexChanged(object sender, EventArgs e)
        {
            repMain_bind();
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowLBdrp();
            repMain_bind();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ShowLBdrp();
            repMain_bind();
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string LinkIds = Request.Form["chxbox"];
            if (!string.IsNullOrEmpty(LinkIds))
            {
                string[] ids = LinkIds.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                foreach (string id in ids)
                {
                    string SortNo = Request.Form["SortNo_" + id];
                    string[] data = new string[] { SortNo };
                    KstCmsBase.DAL.Link.FLink.Link_Update(Convert.ToInt32(id), data, "SortNo");
                }
            }
            repMain_bind();
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string LinkIds = Request.Form["chxbox"];
            if (!string.IsNullOrEmpty(LinkIds))
            {
                string[] ids = LinkIds.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                foreach (string id in ids)
                {
                    KstCmsBase.DAL.Link.FLink.Link_delete(Convert.ToInt32(id));
                }
            }
            repMain_bind();
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int LinkId = Convert.ToInt32(e.CommandName.ToString());
            int isHome = KstCmsBase.DAL.Link.FLink.Get_LinkInfo(LinkId).isHome;
            if (isHome == 1)
                isHome = 0;
            else
                isHome = 1;
            string[] data = new string[] { isHome.ToString() };
            KstCmsBase.DAL.Link.FLink.Link_Update(LinkId, data, "isHome");
            repMain_bind();
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                string enbimg = SysRootUrl + "/KstCMS_Manager/images/enable.gif";
                string digimg = SysRootUrl + "/KstCMS_Manager/images/disable.gif";
                int isHome = ((KstCmsBase.Entities.Link.LinkEnt)e.Item.DataItem).isHome;
                ((ImageButton)e.Item.FindControl("ImageButton1")).ImageUrl = (isHome == 1 ? enbimg : digimg);
                string logo = ((KstCmsBase.Entities.Link.LinkEnt)e.Item.DataItem).LogoUrl;
                if(!string.IsNullOrEmpty(logo)&&logo!="")
                    ((Literal)e.Item.FindControl("lit_LOGO")).Text =" <img src=\"" + SysRootUrl + "/KstCMS_Manager/images/haveimg.gif\" align=\"absmiddle\" style=\"cursor:pointer\" onMouseOver=\"ShowADPreview('<img src=" + logo + " />');\" onMouseOut=\"hideTooltip('dHTMLADPreview');\" />";
                
            }
        }

        void repMain_bind()
        {
            KstCmsBase.Collection.Link.LinkCollection LinkItems = null;
            if (Convert.ToInt32(Act) == 1)
                LinkItems = KstCmsBase.DAL.Link.FLink.Get_Link_Items(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), KstCmsBase.DAL.Link.FLink.LinkType.ActLink);
            else
                LinkItems = KstCmsBase.DAL.Link.FLink.Get_Link_Items(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), KstCmsBase.DAL.Link.FLink.LinkType.NoActLink);
            AspNetPager1.RecordCount = LinkItems.Count;
            System.Collections.ArrayList Items = null;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                Items = LinkItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                Items = LinkItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            PageInfo.Text = "<span style=\"color:red\">" + this.AspNetPager1.RecordCount.ToString() + "</span> ," + this.AspNetPager1.CurrentPageIndex.ToString() + "/" + this.AspNetPager1.PageCount.ToString();
            RepMain.DataSource = Items;
            RepMain.DataBind();
        }
        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            repMain_bind();

        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);

            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection MenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), "MenuID", "MenuName");
            foreach (KstCmsBase.Entities.WebMenu_ent Menu in MenuItems)
            {
                ListItem item = new ListItem();
                item.Value = Menu.MenuID.ToString();
                item.Text = Menu.MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择所属导航", "0"));
        }

        void ShowLBdrp()
        {
            drp_LbList.Items.Clear();
            KstCmsBase.Collection.Link.LinkLBCollection items = KstCmsBase.DAL.Link.FLink.Get_LinkLB_Items();
            foreach (KstCmsBase.Entities.Link.LinkLB lbitem in items)
            {
                ListItem item = new ListItem();
                item.Value = lbitem.LbID.ToString();
                item.Text = lbitem.LbName;
                drp_LbList.Items.Add(item);
            }

        }

    }
}