﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using KstCmsBase.Collection;
using KstCmsBase.Entities;
using KstCmsBase.DAL;

namespace KstCMS.KstCMS_Manager.SystemSet.SoftFace.Menu
{
    public partial class EditMasterMenu : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            Button1.Click += new EventHandler(Button1_Click);
            if (!IsPostBack)
            {
                Set_Validator();
                Button1.Enabled = isAdmin;
            }

            

        }

        void Button1_Click(object sender, EventArgs e)
        {
            string[] SysMenuFieldValues = new string[]{
                
                MENU_NAME.Text.Trim(),
                MENU_IMAGE.Text.Trim(),
                MENU_URL.Text.Trim()
            };
            SysMenu.SysMenu_Update(Request.QueryString.Get("MenuId"), SysMenuFieldValues,  "MENU_NAME", "MENU_IMAGE", "MENU_URL");
            ShowMsgModle("更新成功！", "parent.document.location.reload()");

        }



        private void Set_Validator()
        {
            string[] Attr = new string[5];
            Attr[0] = "菜单代码~int!";
            Attr[1] = "菜单名称~!";
            Attr[2] = "菜单图标~noChinese!";

            base.Set_Control(Attr, MENU_ID, MENU_NAME, MENU_IMAGE);
            MENU_ID.ReadOnly = true;
            MENU_ID.CssClass = "Read_input_text";
            MENU_ID.Text = Request.QueryString.Get("MenuId");
           // SysMenuCollection SysMenuItem = SysMenu.Get_SysMasterMenu();
            SysMenuEntity menu = (new SysMenuCollection()).FindMenuItem(SysMenu.Get_SysMasterMenu(), MENU_ID.Text.Trim());
           // SysMenuEntity menu = SysMenuItem.FindMenuItem(SysMenuItem, MENU_ID.Text.Trim());
            MENU_NAME.Text = menu.MENU_NAME;
            MENU_IMAGE.Text = menu.MENU_IMAGE;
            MENU_URL.Text = menu.MENU_CODE;



        }
    }
}