﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using KstCmsBase.Collection;
using KstCmsBase.Entities;
using KstCmsBase.DAL;

namespace KstCMS.KstCMS_Manager.SystemSet.SoftFace.Menu
{
    public partial class EditSubMenu : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Button1.Click += new EventHandler(Button1_Click);
            if (!IsPostBack)
            {
                Set_Validator();
                Button1.Enabled = isAdmin;
            }
            
        }

        void Button1_Click(object sender, EventArgs e)
        {
            System.Threading.Thread.Sleep(500);
            string MenuId = Request.QueryString.Get("MenuId");
            string[] MenuFieldsValue = new string[]{
                MenuId,
                MENU_NAME.Text.Trim(),
                MENU_CODE.Text.Trim(),
                MENU_IMAGE.Text.Trim()
            };
            SysMenu.SubMenu_Update(MenuId, MenuFieldsValue, "MENU_ID", "MENU_NAME", "MENU_CODE", "MENU_IMAGE");
            ShowMsgModle("修改成功！", "location.href='SubMenuList.aspx?MenuId=" + sMENU_ID.Text.Trim() + "'");
        }


        private void Set_Validator()
        {
            string MenuId = Request.QueryString.Get("MenuId");
            string sMid = MenuId.Substring(0, 2);
            string bMid = MenuId.Substring(2);

            sMENU_ID.Text = sMid;
            MENU_ID.Text = bMid;
            sMENU_ID.ReadOnly = true;
            MENU_ID.ReadOnly = true;
            string[] Attr = new string[5];
            Attr[0] = "菜单代码~4:int!";
            Attr[1] = "菜单名称~!";
            Attr[2] = "菜单图标~noChinese!";
            Attr[3] = "模块地址~noChinese!";

            base.Set_Control(Attr, MENU_ID, MENU_NAME, MENU_IMAGE, MENU_CODE);

            SysMenuEntity menu = (new SysMenuCollection()).FindMenuItem(SysMenu.Get_AllSubMenu(), MenuId);
            MENU_NAME.Text = menu.MENU_NAME;
            MENU_IMAGE.Text = menu.MENU_IMAGE;
            MENU_CODE.Text = menu.MENU_CODE;
        }
    }
}