﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using KstCmsBase.Collection;
using KstCmsBase.Entities;
namespace KstCMS.KstCMS_Manager.SystemSet.SoftFace.Menu
{
    public partial class SubMenuList : KstCmsBase.WebPage.ValidationPage
    {
        protected string MenuId;
        protected void Page_Load(object sender, EventArgs e)
        {
            MenuId = Request.QueryString.Get("MenuId");
            if (!IsPostBack)
            {
                string DelMenuId = Request.QueryString.Get("DelMenuId");
                if (!string.IsNullOrEmpty(DelMenuId))
                    KstCmsBase.DAL.SysMenu.SubMenu_Delete(DelMenuId);
                   
                ShowSubMenu();
            }

        }

        private void ShowSubMenu()
        {
            SysMenuCollection MenuCollection = KstCmsBase.DAL.SysMenu.Get_SysMasterMenu();
            SysMenuEntity Menu = (new SysMenuCollection()).FindMenuItem(MenuCollection, MenuId);

            imgFunc.ImageUrl = SysRootUrl + "/KstCMS_Manager/images/menu/" + Menu.MENU_IMAGE + ".gif";
            litFuncName.Text = Menu.MENU_NAME;

            string html = string.Empty;
            string html_tr = "<tr class=\"TableTd_Gray\">\r\n";
            string html_td = string.Empty;
            string str = string.Empty;

            foreach (SysMenuEntity item in KstCmsBase.DAL.SysMenu.Get_ModelMenu(MenuId))
            {
                string Id = item.MENU_ID;
                str = "<a href=\"EditSubMenu.aspx?MenuId=" + Id + "\">修改</a>";
                if(isAdmin)
                    str += "   |   <a href=\"javascript:\" OnClick=\"var t=confirm('真的删除（" + item.MENU_NAME + "）么？');if(t){DelMenu('" + Id + "','" + MenuId + "');}\">删除</a>";
                html_td = "<td nowrap>";
                html_td += "<img src=\"" + SysRootUrl + "/KstCMS_Manager/images/menu/" + item.MENU_IMAGE + ".gif\" align=\"absmiddle\" /> ";
                html_td += item.MENU_ID + "  " + item.MENU_NAME + "</td>";
                html_td += "<td nowrap>" + str + "</td>";
                html += html_tr + html_td + "</tr>\r\n";
                foreach (SysMenuEntity subitem in  KstCmsBase.DAL.SysMenu.Get_SubMenu(item.MENU_ID))
                {
                    Id = subitem.MENU_ID;
                    str = "<a href=\"EditSubMenu.aspx?MenuId=" + Id + "\">修改</a>   |    <a href=\"javascript:\" OnClick=\"var t=confirm('真的删除（" + subitem.MENU_NAME + "）么？');if(t){DelMenu('" + Id + "','" + MenuId + "');}\">删除</a>";
                    html_td = "<td nowrap>";
                    html_td += "<div style=\"padding-left:30px\"><img src=\"" + SysRootUrl + "/KstCMS_Manager/images/menu/" + subitem.MENU_IMAGE + ".gif\" align=\"absmiddle\" /> ";
                    html_td += subitem.MENU_ID + "  " + subitem.MENU_NAME + "</div></td>";
                    html_td += "<td nowrap>" + str + "</td>";
                    html += html_tr + html_td + "</tr>\r\n";
                }
            }

            Literal1.Text = html;



        }
    }
}