﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.SystemSet.Users.urs
{
    public partial class EditUsers : KstCmsBase.WebPage.FrmControl
    {

        protected string Selected_RoleIds = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Get_UserInfo(Request.QueryString.Get("UserName"));
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string RoleId_List = Request.Form.Get("RoleId_List");
            string Pwd = Request.Form.Get("Password1");
            if (Pwd != Request.Form.Get("Password"))
            {
                throw new Exception("二次输入的密码不一至，请重新输入密码！");
            }
            Pwd = System.Web.Security.FormsAuthentication.HashPasswordForStoringInConfigFile(Pwd, "MD5");
            string[] FieldValues = new string[]{
                UserName.Text.Trim(),
                Pwd,
                YourName.Text.Trim(),
                Email.Text.Trim(),
                RoleId_List
           };
            KstCmsBase.DAL.Users.Users_Update(Convert.ToInt32(lit_UserId.Text.Trim()), FieldValues, "UserName", "UserPwd", "YourName", "Email", "UserRole");
            ShowMsgModle("更新成功！");
        }

        void Get_UserInfo(string UserName)
        {
            KstCmsBase.Entities.UsersEntity TTUser = KstCmsBase.DAL.Users.Get_UserInfo(UserName);
            lit_UserId.Text = TTUser.UserId;
            this.UserName.Text = TTUser.UserName;
            this.YourName.Text = TTUser.YourName;
            Selected_RoleIds = TTUser.UserRole;
            Email.Text = TTUser.Email;
            RoleName_List.Text = TTUser.RoleNameList;
            Set_Control();
            if (TTUser.isAdmin == 1)
            {
                if (isAdmin)
                    OkBtn.Enabled = true;
                else
                    OkBtn.Enabled = false;
            }
        }

        void Set_Control()
        {
            string[] sTitles = new string[]{
                 "用户名~noChinese!",
                 "真实姓名~!",
                 "邮件地址~email!"
            };
            base.Set_Control(sTitles, UserName, YourName,Email);
        }


    }
}