﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.pro
{
    public partial class ProductList : KstCmsBase.WebPage.ValidationPage
    {
        
        string ClassId = System.Web.HttpContext.Current.Server.UrlDecode(System.Web.HttpContext.Current.Request.QueryString["ClassId"]);
        protected void Page_Load(object sender, EventArgs e)
        {
            Button1.Click += new EventHandler(Button1_Click);
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            toSite_drp.SelectedIndexChanged += new EventHandler(toSite_drp_SelectedIndexChanged);
            drp_toMenu.SelectedIndexChanged += new EventHandler(drp_toMenu_SelectedIndexChanged);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            btn_Copy.Click += new EventHandler(btn_Copy_Click);
            btn_Move.Click += new EventHandler(btn_Move_Click);
            link_sort.Click += new EventHandler(link_sort_Click);
            link_prono.Click += new EventHandler(link_prono_Click);
            link_proname.Click += new EventHandler(link_proname_Click);
            link_utime.Click += new EventHandler(link_utime_Click);
            if (!IsPostBack)
            {
                ViewState["IsDOWN"] = true;
                ViewState["Sort"] = KstCmsBase.Collection.Product.ProductCollection.SortFields.uTime;
                ShowSiteDrp();
            }
        }

        void link_utime_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Product.ProductCollection.SortFields.uTime;
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void link_proname_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Product.ProductCollection.SortFields.ProName;
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void link_prono_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Product.ProductCollection.SortFields.ProNo;
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void link_sort_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Product.ProductCollection.SortFields.SortNo;
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int act = Convert.ToInt32(e.CommandArgument.ToString());
            int proid = Convert.ToInt32(e.CommandName.ToString());
            KstCmsBase.Entities.Product.Product_Ent pro = KstCmsBase.DAL.Product.Product.GetProductInfo(proid, "IsNew", "IsTj", "IsHot");
            string[] data = null;
            string ActStr = string.Empty;
            switch (act)
            {
                case 0:
                    ActStr = pro.IsNew == 1 ? "0" : "1";
                    data = new string[] { ActStr };
                    KstCmsBase.DAL.Product.Product.Product_Update(data, proid, "IsNew");
                    break;
                case 1:
                    ActStr = pro.IsTj == 1 ? "0" : "1";
                    data = new string[] { ActStr };
                    KstCmsBase.DAL.Product.Product.Product_Update(data, proid, "IsTj");
                    break;
                case 2:
                    ActStr = pro.IsHot == 1 ? "0" : "1";
                    data = new string[] { ActStr };
                    KstCmsBase.DAL.Product.Product.Product_Update(data, proid, "IsHot");
                    break;
            }
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void btn_Move_Click(object sender, EventArgs e)
        {
            string[] ProIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            KstCmsBase.DAL.Product.Product.ProductMoveTo(ProIds, toSite_drp.SelectedValue, drp_toMenu.SelectedValue, toProlb_drp.SelectedValue);
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void btn_Copy_Click(object sender, EventArgs e)
        {
            string[] ProIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            KstCmsBase.DAL.Product.Product.ProductCopyTo(ProIds, toSite_drp.SelectedValue, drp_toMenu.SelectedValue, toProlb_drp.SelectedValue);
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string[] ProIds = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            for (int i = 0; i < ProIds.Length; i++)
            {
                string SortNo = Request.Form.Get("SortNo_" + ProIds[i]);
                string[] data = new string[] { SortNo };
                KstCmsBase.DAL.Product.Product.Product_Update(data, Convert.ToInt32(ProIds[i]), "SortNo");
            }
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string HtmlExt = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
            string[] ids = Request.Form.Get("chxbox").Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            foreach (string id in ids)
            {
                KstCmsBase.Entities.Product.Product_Ent PRO = KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(id), "SiteID", "MenuID", "Pic1", "Pic2", "Pic3", "FileName");
                string UrlFile = GetSiteMenuUrl(PRO.SiteID, PRO.MenuID);
                KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(UrlFile + PRO.FileName + HtmlExt));
                KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(PRO.Pic1));
                KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(PRO.Pic2));
                KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(PRO.Pic3));
            }
            KstCmsBase.DAL.Product.Product.Products_delete(ids);
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);

        }

        void drp_toMenu_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowtoProLb(toSite_drp.SelectedValue, drp_toMenu.SelectedValue);
        }

        void toSite_drp_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowCopytoMenu(toSite_drp.SelectedValue);
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                string enbimg = SysRootUrl + "/KstCMS_Manager/images/enable.gif";
                string digimg = SysRootUrl + "/KstCMS_Manager/images/disable.gif";
                int IsNew = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).IsNew;
                int IsTj = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).IsTj;
                int IsHot = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).IsHot;
                ((ImageButton)e.Item.FindControl("ImageButton_isnew")).ImageUrl = IsNew == 1 ? enbimg : digimg;
                ((ImageButton)e.Item.FindControl("ImageButton_istj")).ImageUrl = IsTj == 1 ? enbimg : digimg;
                ((ImageButton)e.Item.FindControl("ImageButton_ishot")).ImageUrl = IsHot == 1 ? enbimg : digimg;
                string LitProName = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).ProName;
                string Url = string.Empty;
                int SiteId = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).SiteID;
                int MenuId = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).MenuID;
                if (WebExeute == 1)
                {

                    Url = GetSiteMenuUrl(SiteId, MenuId) + ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).FileName + HtmlExt;
                }
                else
                {
                    string LbId = ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).LbID;
                    LbId = LbId.Substring(0, (LbId.Length-1));
                    Url = SysRootUrl + "/aspx/ShowPro.aspx?SiteId=" + SiteId + "&MenuId=" + MenuId + "&ClassId=" + LbId + "&ProId=" + ((KstCmsBase.Entities.Product.Product_Ent)e.Item.DataItem).ProID;
                }
                ((Literal)e.Item.FindControl("lit_ProName")).Text = "<a href=\"" + Url + "\" target=\"_blank\">" + LitProName + "</a>";
            }
        }





        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ClassId = null;
            repMain_bind(null, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), string.Empty, (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
        }

        void Button1_Click(object sender, EventArgs e)
        {
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
            litMsg.Text = "查找包含[" + txt_KeyWork.Text.Trim() + "]的产品";
        }

        void repMain_bind(string ClassId,int SiteID,int MenuId,string KeyWork,KstCmsBase.Collection.Product.ProductCollection.SortFields Sort)
        {
            string[] data =new string[]{"ProID", "SiteID", "MenuID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "uTime", "IsNew", "IsTj", "IsHot", "SortNo", "FileName"};
            litMsg.Text = "当前站点所有产品.";
             KstCmsBase.Collection.Product.ProductCollection Products  = KstCmsBase.DAL.Product.Product.GetProductList(SiteID, MenuId, null, 0, data);
            if (!string.IsNullOrEmpty(ClassId))
            {
                 Products = KstCmsBase.DAL.Product.Product.GetProductList(ClassId, 0, data);
                string LbId=ClassId;
                string Path=string.Empty;
                if(ClassId.IndexOf(",")!=-1)
                    LbId=ClassId.Substring(ClassId.LastIndexOf(",")+1);
                KstCmsBase.DAL.Product.ProLB.Get_LBPATH(LbId, ref Path);
                litMsg.Text = "所属分类：" + Path;
            }

                if (!string.IsNullOrEmpty(KeyWork) && KeyWork != "")
                {
                    Products = KstCmsBase.DAL.Product.Product.GetProductList(SiteID, MenuId, KeyWork, 0, data);
                }
   
            
            if( (bool)ViewState["IsDOWN"]==true)
                 Products.Sort(Sort, false);
            else
                Products.Sort(Sort, true);
            AspNetPager1.RecordCount = Products.Count;
            System.Collections.ArrayList Proitems = null;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                Proitems = Products.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                Proitems = Products.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            PageInfo.Text = "<span style=\"color:red\">" + this.AspNetPager1.RecordCount.ToString() + "</span> ," + this.AspNetPager1.CurrentPageIndex.ToString() + "/" + this.AspNetPager1.PageSize;
            RepMain.DataSource = Proitems;
            RepMain.DataBind();
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);

        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
                toSite_drp.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            toSite_drp.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
           /* if (drp_SiteList.SelectedValue != "0")
            {
                toSite_drp.Items.Remove(drp_SiteList.SelectedItem);
            }
            */
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ShowCopytoMenu(toSite_drp.SelectedValue);
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 1, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            if (IsPostBack)
                ClassId = null;
            if (!string.IsNullOrEmpty(drp_MenuList.SelectedValue))
                repMain_bind(ClassId, Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), txt_KeyWork.Text.Trim(), (KstCmsBase.Collection.Product.ProductCollection.SortFields)ViewState["Sort"]);
        }

        void ShowCopytoMenu(string SiteId)
        {
            drp_toMenu.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 1, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_toMenu.Items.Add(item);
            }
            drp_toMenu.Items.Insert(0, new ListItem("选所属导航", "0"));
        }
        void ShowtoProLb(string SiteId, string Menuid)
        {
            toProlb_drp.Items.Clear();
            string CacheName = toProlb_drp.ClientID + SiteId.ToString() + Menuid.ToString();
            if (Read_Cache(CacheName) != null)
            {
                foreach (ListItem item in ((DropDownList)Read_Cache(CacheName)).Items)
                    this.toProlb_drp.Items.Add(item);
            }
            else
            {
                KstCmsBase.Common.HtmlControl.ProLB_HtmlControls drp = new KstCmsBase.Common.HtmlControl.ProLB_HtmlControls(SiteId, Menuid);
                drp.ShowDrpProductLbID(0, ref this.toProlb_drp);
                Set_Cache(CacheName, this.toProlb_drp);
            }
            toProlb_drp.Items.Insert(0, new ListItem("选择产品类别", "0"));
        }
    }
}