﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.prolb
{
    public partial class AddFrm : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            drp_ProLBList.SelectedIndexChanged += new EventHandler(drp_ProLBList_SelectedIndexChanged);
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                ShowMenuDrp(drp_SiteList.SelectedValue);
                ShowProductLBdrp(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
                ShowTypeDrp();
                Set_Control();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
            int r = Convert.ToInt32(db.getFieldValue(string.Format("select count(*) as id from ProductLB where SiteID={0} and MenuID={1} and Alias='{2}'", drp_SiteList.SelectedValue, drp_MenuList.SelectedValue,txt_Alias.Text.Trim().ToLower())));
            db.Dispose();
            if (r > 0)
            {
                throw new ExecutionEngineException("对不起！产品类别别名与其它类别别名重复，请新输入！");
            }
           // string IMG = string.Empty;
            string IsTJ = chx_IsTj.Checked ? "1" : "0";
            string[] data = new string[]{
                drp_ProLBList.SelectedValue,
                txt_LbName.Text.Trim(),
                txt_LbIMG.Text.Trim(),
                drp_TypeList.SelectedValue,
                drp_SiteList.SelectedValue,
                drp_MenuList.SelectedValue,
                txt_SortNo.Text.Trim(),
                IsTJ,
                txt_Alias.Text.Trim().ToLower().Replace(" ","_").Replace("\\","_").Replace("/","_").Replace(":","_").Replace("?","_").Replace("\"","_").Replace("<","_").Replace(">","_").Replace("|","_").Replace("*","_"),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                drp_TempList.SelectedValue
            };
            KstCmsBase.DAL.Product.ProLB.Insert(data, "ParentID", "LbName", "LbIMG", "TypeID", "SiteID", "MenuID", "SortNo", "IsTJ", "Alias", "MataKey", "MateDesc", "TempID");
            ShowProductLBdrp(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            ShowMsgModle("操作成功！", "parent.leftFrame.location.href='ProTree.aspx?SiteID=" + drp_SiteList.SelectedValue + "&MenuID=" + drp_MenuList.SelectedValue + "';");
        }

        void drp_ProLBList_SelectedIndexChanged(object sender, EventArgs e)
        {
            drp_TypeList.SelectedValue = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(drp_ProLBList.SelectedValue), "TypeID").TypeID.ToString();
            txt_SortNo.Text = (KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(drp_ProLBList.SelectedValue), "LbID").Count + 1).ToString();
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowProductLBdrp(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            txt_SortNo.Text = (KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(drp_ProLBList.SelectedValue), "LbID").Count + 1).ToString();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
            txt_SortNo.Text = (KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(drp_ProLBList.SelectedValue), "LbID").Count + 1).ToString();
        }


        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 1, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择导航栏", "0"));
        }

        void ShowTypeDrp()
        {
            drp_TypeList.Items.Clear();
            KstCmsBase.Collection.Product.ProductTypeCollection TypeITEMS = KstCmsBase.DAL.Product.ProductType.GetProductTypeList();
            for (int i = 0; i < TypeITEMS.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.Product.ProductType_Ent)TypeITEMS[i]).TypeID.ToString();
                item.Text = ((KstCmsBase.Entities.Product.ProductType_Ent)TypeITEMS[i]).TypeName;
                drp_TypeList.Items.Add(item);
            }
            drp_TypeList.Items.Insert(0, new ListItem("不邦定产品类型", "0"));
        }

        void ShowProductLBdrp(string SiteId,string MenuID)
        {
            drp_ProLBList.Items.Clear();
            KstCmsBase.Common.HtmlControl.ProLB_HtmlControls drp = new KstCmsBase.Common.HtmlControl.ProLB_HtmlControls(SiteId, MenuID);
            drp.Showdrp_LBID(0,ref this.drp_ProLBList);
            drp_ProLBList.Items.Insert(0, new ListItem("根类", "0"));
            
        }

        void Set_Control()
        {
            string[] Cons = new string[]{
                "所属站点~!",
                "所属栏目~!",
                "类别名称~!",
                "类别别名~noChinese~!",
                "MateKey关键字~!",
                "排序~int!"
            };
            base.Set_Control(Cons, drp_SiteList, drp_MenuList, txt_LbName, txt_Alias, txt_MateKey, txt_SortNo);
            txt_SortNo.Attributes.Add("onkeydown", "IsDigit();");
            txt_SortNo.Text = (KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(drp_ProLBList.SelectedValue), "LbID").Count + 1).ToString();
        }

        void ShowDrpTempList(int SiteId)
        {
            drp_TempList.Items.Clear();
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.ProList, SiteId);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));
        }

    }
}