﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.prolb
{
    public partial class ProTree : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            Button1.Click += new EventHandler(Button1_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
            }

        }

        void Button1_Click(object sender, EventArgs e)
        {
            string HtmlExt = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
            for (int i = 0; i < TreeView1.CheckedNodes.Count; i++)
            {
                string LbID = TreeView1.CheckedNodes[i].Value;
                if (TreeView1.CheckedNodes[i].ChildNodes.Count == 0)
                {
                    if (TreeView1.CheckedNodes[i].Depth > 0)
                        TreeView1.CheckedNodes[i].Parent.ChildNodes.Remove(TreeView1.CheckedNodes[i]);
                    else
                        TreeView1.Nodes.Remove(TreeView1.CheckedNodes[i]);
                }
                else
                    throw new ExecutionEngineException("请先删除子分类！");

                KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(LbID), "SiteID", "MenuID", "Alias");
                string UrlFile = GetSiteMenuUrl(ProLB.SiteID, ProLB.MenuID);
                                       KstCmsBase.DAL.Product.ProLB.Delete(LbID, false);
                string[] strFiles = System.IO.Directory.GetFiles(Server.MapPath(UrlFile), ProLB.Alias + "*" + HtmlExt);
                foreach (string file in strFiles)
                    System.IO.File.Delete(file);
            }
            
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowTree();
        }

        void ShowTree()
        {
            TreeView1.Nodes.Clear();
            int Menuid = drp_MenuList.SelectedValue == "" ? 0 : Convert.ToInt32(drp_MenuList.SelectedValue);
            KstCmsBase.Common.HtmlControl.ProLB_HtmlControls ProLB = new KstCmsBase.Common.HtmlControl.ProLB_HtmlControls(drp_SiteList.SelectedValue, Menuid.ToString(), "EditProLB.aspx");
            ProLB.ShowTREE(0, null, ref TreeView1,true);
           

        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ShowTree();
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
            ShowMenuDrp(drp_SiteList.SelectedValue);
            string SiteID = Request.QueryString.Get("SiteID"); string MenuID = Request.QueryString.Get("MenuID");
            if (!string.IsNullOrEmpty(SiteID) && !string.IsNullOrEmpty(MenuID))
            {
                drp_SiteList.SelectedValue = SiteID;
                ShowMenuDrp(SiteID);
                drp_MenuList.SelectedValue = MenuID;
                
            }
            ShowTree();
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 1, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选导航", "0"));
            if (drp_MenuList.Items.Count > 1)
                drp_MenuList.SelectedIndex = 1;
        }
    }
}