﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.products.protype
{
    public partial class Field1List : KstCmsBase.WebPage.ValidationPage
    {
        string TypeID = string.Empty;
        protected string CurrentUrl = string.Empty;
        protected void Page_Load(object sender, EventArgs e)
        {
            CurrentUrl = Request.Url.PathAndQuery;
            TypeID = Request.QueryString.Get("TypeID");
            Button1.Click += new EventHandler(Button1_Click);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            if (!IsPostBack)
            {
                repMain_Bind();
            }
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                int InputType = ((KstCmsBase.Entities.Product.Field1_Ent)e.Item.DataItem).InputType;
                if (InputType == 0)
                {
                    ((Literal)e.Item.FindControl("Literal1")).Text = "";
                    ((Literal)e.Item.FindControl("Literal2")).Text = "disabled=\"disabled\"";
                }
                else
                {
                    ((Literal)e.Item.FindControl("Literal1")).Text = "disabled=\"disabled\" style=\"background-color:#EFEFEF\"";
                    ((Literal)e.Item.FindControl("Literal2")).Text = "";
                }
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int ExtId = Convert.ToInt32(e.CommandArgument.ToString());
            string FieldId = e.CommandName.ToString();
            switch (ExtId)
            {
                case 0:
                    string SortNo = Request.Form["SortNo_" + FieldId];
                    string FieldName = Request.Form["FieldName_" + FieldId];
                    string FieldValue = Request.Form["FieldValue_" + FieldId];
                    string[] data = new string[] { FieldName, FieldValue, SortNo };
                    KstCmsBase.DAL.Product.ProductType.Field1_Update(data, Convert.ToInt32(FieldId), "FieldName", "FieldValue", "SortNo");
                    break;
                case 1:
                    KstCmsBase.DAL.Product.ProductType.Field1_Delete(FieldId);
                    break;

            }
            repMain_Bind();

        }

        void Button1_Click(object sender, EventArgs e)
        {
            int r=KstCmsBase.DAL.Product.ProductType.GetField1List(TypeID).Count+1;
            string[] data = new string[]{
                TypeID,
                txt_FieldName.Text.Trim(),
                drp_InputType.SelectedValue,
                r.ToString()
            };
            KstCmsBase.DAL.Product.ProductType.Field1_Insert(data, "TypeID", "FieldName", "InputType", "SortNo");
            repMain_Bind();
        }

        void repMain_Bind()
        {
            RepMain.DataSource = KstCmsBase.DAL.Product.ProductType.GetField1List(TypeID);
            RepMain.DataBind();
        }
    }
}