﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.wz.wzlist
{
    public partial class EditFrm : KstCmsBase.WebPage.FrmControl
    {
        string WzID = System.Web.HttpContext.Current.Request.QueryString.Get("WzID");
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            drp_lblist.SelectedIndexChanged += new EventHandler(drp_lblist_SelectedIndexChanged);
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                ShowWzInfo();

            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string UrlFileName = string.Empty;
            if (FileName.Value.ToLower() != txt_FileName.Text.Trim())
            {
                UrlFileName = txt_FileName.Text.Trim();
                string HtmlExt = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
                string PathUrl = KstCmsBase.DAL.WebSite.Get_WebSite_Info(Convert.ToInt32(drp_SiteList.SelectedValue), "SiteVer").SiteVer + "/" + KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(Convert.ToInt32(drp_MenuList.SelectedValue), "MenuDiy").MenuDiy;
                PathUrl = SysRootUrl + "/" + PathUrl;
                KstCmsBase.Common.Fucs.DeleteFile(Server.MapPath(PathUrl + "/" + FileName.Value));
            }
            if (string.IsNullOrEmpty(UrlFileName) || UrlFileName == "")
                UrlFileName = KstCmsBase.Common.Fucs.Replace_NoDirStr(DateTime.Now.AddMilliseconds(30).ToString() + "_" + KstCmsBase.Common.Fucs.Rnd(), "_").ToLower();
            string WzPic = WzPic1.Value;
            if (!string.IsNullOrEmpty(txt_WzPic1.Text.Trim()) && txt_WzPic1.Text.Trim() != "")
            {
                if (txt_WzPic1.Text.Trim() != WzPic2.Value)
                {
                    string UpPath = string.Empty;
                    if (Read_Cache("wzpic_path") != null)
                        UpPath = Read_Cache("wzpic_path").ToString();
                    else
                    {
                        UpPath = SysRootUrl + "/" + KstCmsBase.Common.Fucs.GetConfigValue("wzpic_path");
                        Set_Cache("wzpic_path", UpPath);
                    }


                    int PicW, PicH;
                    if (Read_Cache("wzpic_w") != null)
                        PicW = Convert.ToInt32(Read_Cache("wzpic_w"));
                    else
                    {
                        PicW = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("wzpic_w"));
                        Set_Cache("wzpic_w", PicW);
                    }

                    if (Read_Cache("wzpic_h") != null)
                        PicH = Convert.ToInt32(Read_Cache("wzpic_h"));
                    else
                    {
                        PicH = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("wzpic_h"));
                        Set_Cache("wzpic_h", PicH);
                    }

                    KstCmsBase.Common.FStream FS = new KstCmsBase.Common.FStream();
                    WzPic = FS.Set_SmallImg(txt_WzPic1.Text.Trim(), UpPath + "/small/" + DateTime.Now.ToString("yyyy-MM-dd") + "/", PicW, PicH);
                }
            }
            int IsNew = chk_IsNew.Checked ? 1 : 0;
            int IsTj = chk_IsTj.Checked ? 1 : 0;
            int IsHot = chk_IsHot.Checked ? 1 : 0;
            string[] data = new string[]{
                drp_SiteList.SelectedValue,
                drp_MenuList.SelectedValue,
                drp_lblist.SelectedValue,
                txt_WzTile.Text.Trim(),
                WzPic,
                txt_WzPic1.Text.Trim(),
                txt_WzDoc.Value,
                Request.Form["txt_WzContent"].Trim(),
                IsNew.ToString(),
                IsTj.ToString(),
                IsHot.ToString(),
                txt_SortNo.Text.Trim(),
                txt_Utime.Text.Trim(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                UrlFileName,
                drp_TempList.SelectedValue
            };
            KstCmsBase.DAL.Wz.Wz.Wz_Update(Convert.ToInt32(WzID), data, "SiteID", "MenuID", "LbID", "WzTitle", "WzPic", "WzPic1", "WzDoc", "WzContent", "IsNew", "IsTj", "IsHot", "SortNo", "uTime", "MateKey", "MateDesc", "FileName", "TempID");
            ShowMsgModle("修改成功！", "location.href=\"index.aspx?SiteId=" + drp_SiteList.SelectedValue + "&MenuId=" + drp_MenuList.SelectedValue + "&LbId=" + drp_lblist.SelectedValue + "\";");
        }

        void drp_lblist_SelectedIndexChanged(object sender, EventArgs e)
        {
            txt_SortNo.Text = (KstCmsBase.DAL.Wz.Wz.Get_WzList(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(drp_lblist.SelectedValue), false, "WzID").Count + 1).ToString();
            ScriptManager.RegisterStartupScript(this.UpdatePanel1, typeof(UpdatePanel), "", " $(pageInit);", true);
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowLblist(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            ScriptManager.RegisterStartupScript(this.UpdatePanel1, typeof(UpdatePanel), "", " $(pageInit);", true);
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ScriptManager.RegisterStartupScript(this.UpdatePanel1, typeof(UpdatePanel), "", " $(pageInit);", true);
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
           
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 2, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择所属导航", "0"));
        }

        void ShowLblist(string SiteId, string MenuId)
        {
            drp_lblist.Items.Clear();
            KstCmsBase.Collection.Wz.WzLBCollection LbItems = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Convert.ToInt32(SiteId), Convert.ToInt32(drp_MenuList.SelectedValue), "LbID", "LbName");
            foreach (KstCmsBase.Entities.Wz.WzLB_Ent lb in LbItems)
            {
                ListItem item = new ListItem();
                item.Value = lb.LbID.ToString();
                item.Text = lb.LbName;
                drp_lblist.Items.Add(item);
            }
            drp_lblist.Items.Insert(0, new ListItem("请选择所属类别", "0"));
        }

        void Set_Control()
        {
            string[] Cons = new string[] { "所属导航~!", "所属分类~!", "文章标题~!", "排序~int!", "日期~date!","文件名~!" };
            base.Set_Control(Cons, drp_MenuList, drp_lblist, txt_WzTile, txt_SortNo, txt_Utime, txt_FileName);
            txt_SortNo.Attributes.Add("onkeydown", "IsDigit();");
            
        }


        void ShowDrpTempList(int SiteId)
        {
            drp_TempList.Items.Clear();
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.WzContent, SiteId);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));
        }

        void ShowWzInfo()
        {
            KstCmsBase.Entities.Wz.Wz_Ent wz = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Convert.ToInt32(WzID));
            ShowSiteDrp();
            drp_SiteList.SelectedValue = wz.SiteID.ToString();
            ShowMenuDrp(drp_SiteList.SelectedValue);
            drp_MenuList.SelectedValue = wz.MenuID.ToString();
            ShowLblist(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            drp_lblist.SelectedValue = wz.LbID.ToString();
            txt_WzTile.Text = wz.WzTitle;
            WzPic1.Value = wz.WzPic;
            WzPic2.Value = wz.WzPic1;
            txt_WzPic1.Text = wz.WzPic1;
            txt_WzDoc.Value = wz.WzDoc;
            txt_WzContent.Value = wz.WzContent;
            chk_IsNew.Checked = wz.IsNew == 1;
            chk_IsTj.Checked = wz.IsTj == 1;
            chk_IsHot.Checked = wz.IsHot == 1;
            txt_SortNo.Text = wz.SortNo.ToString();
            txt_Utime.Text = wz.uTime.ToString("yyyy-MM-dd");
            txt_MateKey.Text = wz.MateKey;
            txt_MateDesc.Text = wz.MateDesc;
            txt_FileName.Text = wz.FileName;
            FileName.Value = wz.FileName;
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
            drp_TempList.SelectedValue = wz.TempID.ToString();
            Set_Control();
        }

    }
}