﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebContent.wz.wzlist
{
    public partial class index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            drp_MenuList.SelectedIndexChanged += new EventHandler(drp_MenuList_SelectedIndexChanged);
            drp_lblist.SelectedIndexChanged += new EventHandler(drp_lblist_SelectedIndexChanged);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            btn_Del.Click += new EventHandler(btn_Del_Click);
            btn_Sort.Click += new EventHandler(btn_Sort_Click);
            link_sort.Click += new EventHandler(link_sort_Click);
            link_wztitle.Click += new EventHandler(link_wztitle_Click);
            link_utime.Click += new EventHandler(link_utime_Click);
            if (!IsPostBack)
            {

                ShowSiteDrp();
                if (!string.IsNullOrEmpty(drp_SiteList.SelectedValue) && drp_SiteList.SelectedValue != "")
                    ShowMenuDrp(drp_SiteList.SelectedValue);
                if (!string.IsNullOrEmpty(drp_MenuList.SelectedValue) && drp_MenuList.SelectedValue != "")
                {

                    ShowLblist(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
                    ///用于录入后显示录入对应的分类的文章
                        string SiteId = Request.QueryString.Get("SiteId");
                        string MenuId = Request.QueryString.Get("SiteId");
                        string LbId = Request.QueryString.Get("LbId");
                        if (!string.IsNullOrEmpty(SiteId)) drp_SiteList.SelectedValue = SiteId;
                        if (!string.IsNullOrEmpty(MenuId)) drp_MenuList.SelectedValue = MenuId;
                        if (!string.IsNullOrEmpty(LbId)) drp_lblist.SelectedValue = LbId;
                   ViewState["IsDOWN"] = true;
                   ViewState["Sort"] = KstCmsBase.Collection.Wz.WzCollection.SortFields.SortNo;
                   RepMain_bind();
                }

            }
        }

        void link_utime_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Wz.WzCollection.SortFields.uTime;
            RepMain_bind();
        }

        void link_wztitle_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Wz.WzCollection.SortFields.WzTitle;
            RepMain_bind();
        }

        void link_sort_Click(object sender, EventArgs e)
        {
            if ((bool)ViewState["IsDOWN"])
                ViewState["IsDOWN"] = false;
            else
                ViewState["IsDOWN"] = true;
            ViewState["Sort"] = KstCmsBase.Collection.Wz.WzCollection.SortFields.SortNo;
            RepMain_bind();
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int act = Convert.ToInt32(e.CommandArgument.ToString());
            int wzid = Convert.ToInt32(e.CommandName.ToString());
            KstCmsBase.Entities.Wz.Wz_Ent WZ = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(wzid, "IsNew", "IsTj", "IsHot");
            string[] data = null;
            string ActStr = string.Empty;
            switch (act)
            {
                case 0:
                    ActStr = WZ.IsNew == 1 ? "0" : "1";
                    data = new string[] { ActStr };
                    KstCmsBase.DAL.Wz.Wz.Wz_Update(wzid,data, "IsNew");
                    break;
                case 1:
                    ActStr = WZ.IsTj == 1 ? "0" : "1";
                    data = new string[] { ActStr };
                    KstCmsBase.DAL.Wz.Wz.Wz_Update(wzid, data, "IsTj");
                    break;
                case 2:
                    ActStr = WZ.IsHot == 1 ? "0" : "1";
                    data = new string[] { ActStr };
                    KstCmsBase.DAL.Wz.Wz.Wz_Update(wzid, data, "IsHot");
                    break;
            }
            RepMain_bind();
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                string WzPic = ((KstCmsBase.Entities.Wz.Wz_Ent)e.Item.DataItem).WzPic;
                if (!string.IsNullOrEmpty(WzPic) && WzPic != "")
                    ((Literal)e.Item.FindControl("lit_pic")).Text = " <img src=\"" + SysRootUrl + "/KstCMS_Manager/images/haveimg.gif\" align=\"absmiddle\" style=\"cursor:pointer\" onMouseOver=\"ShowADPreview('<img src=" + WzPic + " />');\" onMouseOut=\"hideTooltip('dHTMLADPreview');\" />";
                int isNew = ((KstCmsBase.Entities.Wz.Wz_Ent)e.Item.DataItem).IsNew;
                int isTj = ((KstCmsBase.Entities.Wz.Wz_Ent)e.Item.DataItem).IsTj;
                int isHot = ((KstCmsBase.Entities.Wz.Wz_Ent)e.Item.DataItem).IsHot;
                string enbimg = SysRootUrl + "/KstCMS_Manager/images/enable.gif";
                string digimg = SysRootUrl + "/KstCMS_Manager/images/disable.gif";
                ((ImageButton)e.Item.FindControl("ImageButton_isnew")).ImageUrl = isNew == 1 ? enbimg : digimg;
                ((ImageButton)e.Item.FindControl("ImageButton_istj")).ImageUrl = isTj == 1 ? enbimg : digimg;
                ((ImageButton)e.Item.FindControl("ImageButton_ishot")).ImageUrl = isHot == 1 ? enbimg : digimg;
            }
           
        }

        void btn_Sort_Click(object sender, EventArgs e)
        {
            string ids = Request.Form.Get("chxbox");
            if (!string.IsNullOrEmpty(ids))
            {
                string[] s = ids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < s.Length; i++)
                {
                    string[] data = new string[] { Request.Form.Get("SortNo_" + s[i]) };
                    KstCmsBase.DAL.Wz.Wz.Wz_Update(Convert.ToInt32(s[i]), data, "SortNo");
                }
            }
            RepMain_bind();
        }

        void btn_Del_Click(object sender, EventArgs e)
        {
            string HtmlExt=KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
            string ids = Request.Form.Get("chxbox");
            if (!string.IsNullOrEmpty(ids))
            {
                string[] s = ids.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                for (int i = 0; i < s.Length; i++)
                {
                    KstCmsBase.Entities.Wz.Wz_Ent WZ = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Convert.ToInt32(s[i]), "SiteID", "MenuID", "FileName");
                    string UrlFile = Server.MapPath(GetSiteMenuUrl(WZ.SiteID, WZ.MenuID) + WZ.FileName + HtmlExt);
                    KstCmsBase.DAL.Wz.Wz.Wz_Delete(Convert.ToInt32(s[i]));
                    KstCmsBase.Common.Fucs.DeleteFile(UrlFile);
                }
            }
            RepMain_bind();
        }

        void drp_lblist_SelectedIndexChanged(object sender, EventArgs e)
        {
            RepMain_bind();
        }

        void drp_MenuList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowLblist(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            RepMain_bind();
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ShowLblist(drp_SiteList.SelectedValue, drp_MenuList.SelectedValue);
            RepMain_bind();
        }

        void RepMain_bind()
        {
            KstCmsBase.Collection.Wz.WzCollection WzList = null;
            if (keywork.Text.Trim() != "")
                WzList = KstCmsBase.DAL.Wz.Wz.Get_WzList(keywork.Text.Trim(), Convert.ToInt32(drp_SiteList.SelectedValue), "WzID", "WzTitle", "WzPic", "uTime", "SortNo","IsNew","IsTj","IsHot");
            else
            {
                if (drp_MenuList.SelectedValue != "" && !string.IsNullOrEmpty(drp_MenuList.SelectedValue))
                    WzList = KstCmsBase.DAL.Wz.Wz.Get_WzList(Convert.ToInt32(drp_SiteList.SelectedValue), Convert.ToInt32(drp_MenuList.SelectedValue), Convert.ToInt32(drp_lblist.SelectedValue), false, "WzID", "WzTitle", "WzPic", "uTime", "SortNo", "IsNew", "IsTj", "IsHot");
            }
            KstCmsBase.Collection.Wz.WzCollection.SortFields Sort = (KstCmsBase.Collection.Wz.WzCollection.SortFields)ViewState["Sort"];
            if ((bool)ViewState["IsDOWN"] == true)
                WzList.Sort(Sort, false);
            else
                WzList.Sort(Sort, true);
            System.Collections.ArrayList items = null;
            AspNetPager1.RecordCount = WzList.Count;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                items = WzList.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                items = WzList.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            PageInfo.Text = "<span style=\"color:red\">" + this.AspNetPager1.RecordCount.ToString() + "</span> ," + this.AspNetPager1.CurrentPageIndex.ToString() + "/" + this.AspNetPager1.PageCount.ToString();
            RepMain.DataSource = items;
            RepMain.DataBind();
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_bind();

        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 2, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选导航", "0"));
            if (drp_MenuList.Items.Count > 1)
                drp_MenuList.SelectedIndex = 1;
        }

        void ShowLblist(string SiteId, string MenuId)
        {
            drp_lblist.Items.Clear();
            KstCmsBase.Collection.Wz.WzLBCollection LbItems = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Convert.ToInt32(SiteId), Convert.ToInt32(drp_MenuList.SelectedValue), "LbID", "LbName");
            foreach (KstCmsBase.Entities.Wz.WzLB_Ent lb in LbItems)
            {
                ListItem item = new ListItem();
                item.Value = lb.LbID.ToString();
                item.Text = lb.LbName;
                drp_lblist.Items.Add(item);
            }
            drp_lblist.Items.Insert(0, new ListItem("请选择所属类别", "0"));
        }

    }
}