﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Ad
{
    public partial class index : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            if (!IsPostBack)
            {
                RepMain_Bind();
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int Act = Convert.ToInt32(e.CommandArgument.ToString());
            int Adid = Convert.ToInt32(e.CommandName.ToString());
            switch (Act)
            {
                case 0:
                    KstCmsBase.DAL.Ad.PicPlay.PicPlay_Delete(Adid);
                    RepMain_Bind();
                    break;
                case 1:
                    KstCmsBase.Entities.Ad.PicPlay_Ent PicPlay = KstCmsBase.DAL.Ad.PicPlay.Get_PicPlayInfo(Adid);
                    Literal1.Text = "<span style=\"color:Red\">&lt;script type=\"text/javascript\" language=\"javascript\" src=\"";
                    Literal1.Text += SysRootUrl + "/Scripts/PicPlay/" + PicPlay.ExeFile + "?Adid=" + Adid.ToString() + "\"&gt;&lt;/script&gt;</span>";
                    break;
            }
        }

        void RepMain_Bind()
        {
            System.Collections.ArrayList items = null;
            KstCmsBase.Collection.Ad.PicPlayCollection PicPlayItems = KstCmsBase.DAL.Ad.PicPlay.Get_PicPlayItems();
            AspNetPager1.RecordCount = PicPlayItems.Count;
            if (AspNetPager1.RecordCount == 0)
                AspNetPager1.CurrentPageIndex = 0;
            if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
            {
                items = PicPlayItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
            }
            else
            {
                int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                items = PicPlayItems.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
            }
            RepMain.DataSource = items;
            RepMain.DataBind();
        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_Bind();

        }
    }
}