﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.systag
{
    public partial class SystagLB : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Button3.Click += new EventHandler(Button3_Click);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            if (!IsPostBack)
            {
                RepMain_Bind();
                //int isAdmin = KstCmsBase.DAL.Users.Get_UserInfo(User.Identity.Name).isAdmin;
                this.Button3.Enabled = isAdmin;
            }
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
               // int isAdmin = KstCmsBase.DAL.Users.Get_UserInfo(User.Identity.Name).isAdmin;
                ((Button)e.Item.FindControl("Button1")).Enabled = isAdmin;
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int Act = Convert.ToInt32(e.CommandArgument.ToString());
            int TagLBID = Convert.ToInt32(e.CommandName.ToString());
            switch (Act)
            {
                case 0:
                    string[] data = new string[] { Request.Form.Get("TagLBNAME_" + TagLBID.ToString()) };
                    KstCmsBase.DAL.Tag.SysTAG.SysTAGLB_Update(TagLBID, data, "LbNAME");
                    break;
                case 1:
                    KstCmsBase.DAL.Tag.SysTAG.SysTAGLB_delete(TagLBID);
                    break;
            }
            RepMain_Bind();
        }

        void Button3_Click(object sender, EventArgs e)
        {
            string[] data = new string[] { txt_TagLBNAME.Text.Trim() };
            KstCmsBase.DAL.Tag.SysTAG.SysTAGLB_Insert(data, "LbNAME");
            RepMain_Bind();
        }
        void RepMain_Bind()
        {
            RepMain.DataSource = KstCmsBase.DAL.Tag.SysTAG.GetSysTAGLB_Items();
            RepMain.DataBind();
        }
    }
}