﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tagdoc
{
    public partial class AddFRM : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                ShowDrpLB();
                SetControl();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string[] data = new string[]{
                drp_TempLB.SelectedValue,
                txt_TagName.Text.Trim(),
                txt_TagDesc.Value.Trim(),
                UtimeFormat.SelectedValue
           };
            KstCmsBase.DAL.Tag.TagTEMP.TagDESC_Insert(data, "LBID", "TagName", "DescTAG", "uTimeFormat");
            ShowMsgModle("增加成功！", "location.href='DescList.aspx?lbid" + drp_TempLB.SelectedValue + "';");
        }

        void ShowDrpLB()
        {
            KstCmsBase.Collection.Tag.TagDescLBCollection LbItems = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDescLBItems();
            foreach (KstCmsBase.Entities.Tag.TagDESCLB_ent lb in LbItems)
            {
                ListItem item = new ListItem();
                item.Value = lb.LBID.ToString();
                item.Text = lb.LBNAME;
                drp_TempLB.Items.Add(item);
            }
            drp_TempLB.Items.Insert(0, new ListItem("请选择所属类别", "0"));
        }

        void SetControl()
        {
            string[] Cons = new string[]{
                "所属分类~!",
                "标签名称~!",
            };
            base.Set_Control(Cons, drp_TempLB, txt_TagName);
        }
    }
}