﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tagdoc
{
    public partial class EditFrm : KstCmsBase.WebPage.FrmControl
    {
        string TagId = System.Web.HttpContext.Current.Request.QueryString.Get("TagID");
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Get_TagData();
                SetControl();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string[] data = new string[]{
                drp_TempLB.SelectedValue,
                txt_TagName.Text.Trim(),
                txt_TagDesc.Value.Trim(),
                UtimeFormat.SelectedValue
           };
            KstCmsBase.DAL.Tag.TagTEMP.TagDESC_Update(Convert.ToInt32(TagId), data, "LBID", "TagName", "DescTAG", "uTimeFormat");
            ShowMsgModle("修改成功！", "location.href='DescList.aspx?lbid" + drp_TempLB.SelectedValue + "';");
        }

        void Get_TagData()
        {
            KstCmsBase.Entities.Tag.TagDESC_ent TagDESC = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDESC(Convert.ToInt32(TagId));
            txt_TagName.Text = TagDESC.TagName;
            txt_TagDesc.Value = TagDESC.ContentTAG;
            ShowDrpLB();
            drp_TempLB.SelectedValue = TagDESC.TagLbID.ToString();
            UtimeFormat.SelectedValue = TagDESC.uTimeFormat.ToString();  
        }

        void ShowDrpLB()
        {
            KstCmsBase.Collection.Tag.TagDescLBCollection LbItems = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDescLBItems();
            foreach (KstCmsBase.Entities.Tag.TagDESCLB_ent lb in LbItems)
            {
                ListItem item = new ListItem();
                item.Value = lb.LBID.ToString();
                item.Text = lb.LBNAME;
                drp_TempLB.Items.Add(item);
            }
            drp_TempLB.Items.Insert(0, new ListItem("请选择所属类别", "0"));
        }

        void SetControl()
        {
            string[] Cons = new string[]{
                "所属分类~!",
                "标签名称~!",
            };
            base.Set_Control(Cons, drp_TempLB, txt_TagName);
        }


    }
}