﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tagtmp
{
    public partial class TagTempList : KstCmsBase.WebPage.ValidationPage
    {
        string lbid = System.Web.HttpContext.Current.Request.QueryString.Get("lbid");
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_Lblist.SelectedIndexChanged += new EventHandler(drp_Lblist_SelectedIndexChanged);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            if (!IsPostBack)
            {
                ShowdrpList();
                if (!string.IsNullOrEmpty(lbid))
                    drp_Lblist.SelectedValue = lbid;
                RepMain_Bind();
            }
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            string TagID = e.CommandName.ToString();
            KstCmsBase.DAL.Tag.TagTEMP.TagTemp_Delete(Convert.ToInt32(TagID));
            RepMain_Bind();

        }

        void drp_Lblist_SelectedIndexChanged(object sender, EventArgs e)
        {
            RepMain_Bind();
        }

        void RepMain_Bind()
        {
            if (!string.IsNullOrEmpty(drp_Lblist.SelectedValue))
            {
                KstCmsBase.Collection.Tag.TagTempCollection TagTEMPITEMS = KstCmsBase.DAL.Tag.TagTEMP.GetTagTempItems(Convert.ToInt32(drp_Lblist.SelectedValue));
                System.Collections.ArrayList items = null;
                AspNetPager1.RecordCount = TagTEMPITEMS.Count;
                if (AspNetPager1.RecordCount == 0)
                    AspNetPager1.CurrentPageIndex = 0;
                if (AspNetPager1.CurrentPageIndex * AspNetPager1.PageSize < AspNetPager1.RecordCount)
                {
                    items=TagTEMPITEMS.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), AspNetPager1.PageSize);
                }
                else
                {
                    int EndCount = AspNetPager1.RecordCount - ((AspNetPager1.CurrentPageIndex - 1) * AspNetPager1.PageSize);
                    items=TagTEMPITEMS.GetRange(AspNetPager1.PageSize * (AspNetPager1.CurrentPageIndex - 1), EndCount);
                }
                RepMain.DataSource = items;
                RepMain.DataBind();
            }
        }
        void ShowdrpList()
        {
            KstCmsBase.Collection.Tag.TagTempLBCollection TagTempLBItems = KstCmsBase.DAL.Tag.TagTEMP.TagTempLBItems();
            foreach (KstCmsBase.Entities.Tag.TagTEMPLB_ent TagLB in TagTempLBItems)
            {
                ListItem item = new ListItem();
                item.Value = TagLB.TagLBID.ToString();
                item.Text = TagLB.TagLBNAME;
                drp_Lblist.Items.Add(item);
            }

        }

        public void AspNetPager1_PageChanged(object src, Webdiver.PageChangedEventArgs e)
        {
            this.AspNetPager1.CurrentPageIndex = e.NewPageIndex;
            RepMain_Bind();

        }
    }
}