﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tmp
{
    public partial class LmPage : KstCmsBase.WebPage.ValidationPage
    {
        protected string TypeId = System.Web.HttpContext.Current.Request.QueryString.Get("TypeId");
        protected void Page_Load(object sender, EventArgs e)
        {
            RepMain.ItemDataBound += new RepeaterItemEventHandler(RepMain_ItemDataBound);
            RepMain.ItemCommand += new RepeaterCommandEventHandler(RepMain_ItemCommand);
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            if (!IsPostBack)
            {
                base.Save_TempUrl(Request.Url.PathAndQuery);
                ShowSiteDrp();
                repMain_Bind();
            }
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            repMain_Bind();
        }

        void RepMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            int Action = Convert.ToInt32(e.CommandArgument.ToString());
            switch (Action)
            {
                case 0:
                    KstCmsBase.DAL.Templates.SetTempDefalutAct(e.CommandName.ToString(), KstCmsBase.DAL.Templates.TempType.LmPage);
                    break;
                case 1:
                    KstCmsBase.DAL.Templates.TempDelete(e.CommandName.ToString());
                    break;
            }
            repMain_Bind();
        }

        void RepMain_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
            if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
            {
                string SiteName = KstCmsBase.DAL.WebSite.Get_WebSite_Info(((KstCmsBase.Entities.Template_Ent)e.Item.DataItem).SiteID, "SiteName").SiteName;
                ((Literal)e.Item.FindControl("lit_SiteName")).Text = SiteName;
                int DefaultAct = ((KstCmsBase.Entities.Template_Ent)e.Item.DataItem).DefaultAct;
                if (DefaultAct == 1)
                {
                    ((ImageButton)e.Item.FindControl("ImageButton1")).ImageUrl = SysRootUrl + "/KstCMS_Manager/images/enable.gif";
                    ((Button)e.Item.FindControl("Button1")).Enabled = false;
                }
                else
                {
                    ((Button)e.Item.FindControl("Button1")).Enabled = true;
                    ((ImageButton)e.Item.FindControl("ImageButton1")).ImageUrl = SysRootUrl + "/KstCMS_Manager/images/disable.gif";
                }

            }
        }


        void repMain_Bind()
        {
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.LmPage, Convert.ToInt32(drp_SiteList.SelectedValue));
            RepMain.DataSource = TempItems;
            RepMain.DataBind();
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);

            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();
        }
    }
    
}