﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.Template.tmp
{
    public partial class Template_edit : KstCmsBase.WebPage.ValidationPage
    {
        string TempId = System.Web.HttpContext.Current.Request.QueryString.Get("TempId");
        protected void Page_Load(object sender, EventArgs e)
        {
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                ShowSiteDrp();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            string[] data = new string[]{
                drp_SiteList.SelectedValue,
                txt_TempName.Text.Trim(),
                txt_TempContent.Value,
           };
            KstCmsBase.DAL.Templates.TempUpdate(Convert.ToInt32(TempId), data, "SiteID", "TempName", "TempContent");
            ShowMsgModle("修改成功！", "location.href='" + Get_TempUrl(Request.Url.PathAndQuery) + "';");
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);

            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            // drp_SiteList.SelectedValue = base.DefaultSite.SiteID.ToString();

            KstCmsBase.Entities.Template_Ent Template = KstCmsBase.DAL.Templates.GetTemplate(TempId);
            drp_SiteList.SelectedValue = Template.SiteID.ToString();
            txt_TempName.Text = Template.TempName;
            txt_TempContent.Value = Template.TempContent;
        }
    }
}