﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.WebMenu
{
    public partial class AddMenu : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Set_Control();
            }
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
        }

        void OkBtn_Click(object sender, EventArgs e)
        {

            string FileDir = txt_MenuDiy.Text.Trim().ToLower();
            string SiteDir = ((KstCmsBase.Entities.WebSite_ent)KstCmsBase.DAL.WebSite.Get_WebSite_Info(Convert.ToInt32(drp_SiteList.SelectedValue), "SiteVer")).SiteVer;
            if (chx_IsOutUrl.Checked)
            {
                if (txt_GoUrl.Text[0].ToString() != "/" && txt_GoUrl.Text.ToLower().IndexOf("http://") == -1)
                {
                    throw new ExecutionEngineException("如果是外部链接，此处应该是绝对路径\"/\"或\"http://\"开头的。");
                }
                FileDir = "";
            }
            else
            {
                            KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
                            if (Convert.ToInt32(db.getFieldValue(string.Format("select count(*) as row from WebMenu where SiteID={0} and MenuDiy='{1}'", drp_SiteList.SelectedValue, FileDir))) > 0)
                            {
                                throw new ExecutionEngineException("文件目录已存在！");
                            }
            }
            string IsOutUrl = chx_IsOutUrl.Checked ? "1" : "0";
            string Act = chx_Act.Checked ? "1" : "0";
            string IsShow = chx_IsShow.Checked ? "1" : "0";
            string[] data = new string[]{
                drp_SiteList.SelectedValue,
                txt_MenuName.Text.Trim(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                FileDir,
                txt_GoUrl.Text.Trim(),
                IsOutUrl,
                "0",
                RadioButtonList1.SelectedValue,
                Act,
                txt_SortNo.Text.Trim(),
                drp_TempList.SelectedValue,
                IsShow
            };
            KstCmsBase.DAL.WebMenu.Insert(data, "SiteID", "MenuName", "MateKey", "MateDesc", "MenuDiy", "GoUrl", "IsOutUrl", "GoLmID", "AttRib", "Act", "SortNo", "TempID", "IsShow");
            if (FileDir != "" && !string.IsNullOrEmpty(FileDir))
            {
                //创建目录
                KstCmsBase.Common.Fucs.CreateDir(Server.MapPath("~/" + SiteDir + "/" + FileDir));
            }
            ShowMsgModle("增加成功！", "parent.document.location.reload();");
        }

        void Set_Control()
        {
            ShowSiteDrp();
            chx_IsOutUrl.Attributes.Add("onclick", "onClickOutLink();");
            txt_SortNo.Attributes.Add("onkeydown", "IsDigit();");
            
        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
        }

        void ShowDrpTempList(int SiteId)
        {
            drp_TempList.Items.Clear();
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.LmPage, SiteId);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));

        }

    }
}