﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.WebMenu
{
    public partial class MenuList : KstCmsBase.WebPage.ValidationPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteId.SelectedIndexChanged += new EventHandler(drp_SiteId_SelectedIndexChanged);
            repMain.ItemCommand += new RepeaterCommandEventHandler(repMain_ItemCommand);
            if (!IsPostBack)
            {
                ShowSiteDrp();
                rpMain_Bind();
            }
        }

        void repMain_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            KstCmsBase.Entities.WebMenu_ent WebMenu = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(Convert.ToInt32(e.CommandName.ToString()),"SiteID", "MenuDiy","IsOutUrl");
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(WebMenu.SiteID, "SiteVer");
            KstCmsBase.DAL.WebMenu.Delete(e.CommandName.ToString());
            if (WebMenu.IsOutUrl != 1)
                KstCmsBase.Common.Fucs.DeleteDir(Server.MapPath("~/" + WebSite.SiteVer + "/" + WebMenu.MenuDiy));
            rpMain_Bind();
        }

        void drp_SiteId_SelectedIndexChanged(object sender, EventArgs e)
        {
            rpMain_Bind();
        }



        void rpMain_Bind()
        {
            if (!string.IsNullOrEmpty(drp_SiteId.SelectedValue))
            {
                this.repMain.DataSource = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(drp_SiteId.SelectedValue));
                this.repMain.DataBind();
            }
        }
        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1,"SiteID","SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteId.Items.Add(item);
            }
        }
    }
}