﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KstCMS.KstCMS_Manager.WebSet.upage
{
    public partial class LMEdit : KstCmsBase.WebPage.FrmControl
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            drp_SiteList.SelectedIndexChanged += new EventHandler(drp_SiteList_SelectedIndexChanged);
            OkBtn.Click += new EventHandler(OkBtn_Click);
            if (!IsPostBack)
            {
                Set_Control();
                Get_LmInfo();
            }
        }

        void OkBtn_Click(object sender, EventArgs e)
        {
            int Act = chx_Act.Checked ? 1 : 0;
            string[] data = new string[]{
                drp_SiteList.SelectedValue,
                drp_MenuList.SelectedValue,
                txt_LmName.Text.Trim(),
                txt_uPageFile.Text.Trim().ToLower(),
                txt_MateKey.Text.Trim(),
                txt_MateDesc.Text.Trim(),
                txt_SortNo.Text.Trim(),
                Act.ToString(),
                drp_TempList.SelectedValue
            };
            KstCmsBase.DAL.WebLM.Update(data, Convert.ToInt32(Request.QueryString.Get("LmID")), "SiteID", "MenuID", "LmName", "uPageFile", "MateKey", "MateDesc", "SortNo", "Act", "TempID");
            ShowMsgModle("设置成功！");
        }

        void drp_SiteList_SelectedIndexChanged(object sender, EventArgs e)
        {
            ShowMenuDrp(drp_SiteList.SelectedValue);
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
        }
        void Set_Control()
        {
            
            txt_SortNo.Attributes.Add("onkeydown", "IsDigit();");
        }

        void Get_LmInfo()
        {
            ShowSiteDrp();
            KstCmsBase.Entities.WebLm_ent WebLM = KstCmsBase.DAL.WebLM.Get_WebLMInfo(Convert.ToInt32(Request.QueryString.Get("LmID")));
            drp_SiteList.SelectedValue = WebLM.SiteID.ToString();
            ShowMenuDrp(drp_SiteList.SelectedValue);
            drp_MenuList.SelectedValue = WebLM.MenuID.ToString();
            txt_LmName.Text = WebLM.LmName;
            txt_uPageFile.Text = WebLM.uPageFile;
            txt_uPageFile.Enabled = false;
            txt_MateKey.Text = WebLM.MateKey;
            txt_MateDesc.Text = WebLM.MateDesc;
            chx_Act.Checked = WebLM.Act == 1;
            txt_SortNo.Text = WebLM.SortNo.ToString();
            ShowDrpTempList(Convert.ToInt32(drp_SiteList.SelectedValue));
            drp_TempList.SelectedValue = WebLM.TempID.ToString();

        }

        void ShowSiteDrp()
        {
            KstCmsBase.Collection.WebSite_Collection WebSiteItems = KstCmsBase.DAL.WebSite.Get_WebSiteList(1, "SiteID", "SiteName");
            for (int i = 0; i < WebSiteItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteID.ToString();
                item.Text = ((KstCmsBase.Entities.WebSite_ent)WebSiteItems[i]).SiteName;
                drp_SiteList.Items.Add(item);
            }
            drp_SiteList.Items.Insert(0, new ListItem("请选择站点", "0"));
        }

        void ShowMenuDrp(string SiteId)
        {
            drp_MenuList.Items.Clear();
            KstCmsBase.Collection.WebMenuCollection WebMenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(Convert.ToInt32(SiteId), 1, 0, "MenuID", "MenuName");
            for (int i = 0; i < WebMenuItems.Count; i++)
            {
                ListItem item = new ListItem();
                item.Value = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuID.ToString();
                item.Text = ((KstCmsBase.Entities.WebMenu_ent)WebMenuItems[i]).MenuName;
                drp_MenuList.Items.Add(item);
            }
            drp_MenuList.Items.Insert(0, new ListItem("请选择导航栏", "0"));
        }

        void ShowDrpTempList(int SiteId)
        {
            drp_TempList.Items.Clear();
            KstCmsBase.Collection.TempCollection TempItems = KstCmsBase.DAL.Templates.GetTemplatesItems(KstCmsBase.DAL.Templates.TempType.uPage, SiteId);
            foreach (KstCmsBase.Entities.Template_Ent Temp in TempItems)
            {
                ListItem item = new ListItem();
                item.Value = Temp.TempID.ToString();
                item.Text = Temp.TempName;
                if (Temp.DefaultAct == 1)
                    item.Selected = true;
                drp_TempList.Items.Add(item);
            }
            drp_TempList.Items.Insert(0, new ListItem("请选择模板", "0"));

        }
    }
}