﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCmsBase.Collection.Feeback
{
    public class LyListCollection:BaseCollection
    {
        public enum SortFields { Cname, LyTitle, Lytime }
        public void Sort(SortFields SortField, bool isAscending)
        {
            switch (SortField)
            {
                case SortFields.Cname:
                    base.Sort(new Cname_Comparer());
                    break;
                case SortFields.LyTitle:
                    base.Sort(new LyTitle_Comparer());
                    break;
                case SortFields.Lytime:
                    base.Sort(new Lytime_Comparer());
                    break;
            }
            if (!isAscending) base.Reverse();
        }

        private sealed class Cname_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Feeback.LyEnt first = (KstCmsBase.Entities.Feeback.LyEnt)x;
                KstCmsBase.Entities.Feeback.LyEnt second = (KstCmsBase.Entities.Feeback.LyEnt)y;
                return first.CName.CompareTo(second.CName);
            }
        }

        private sealed class LyTitle_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Feeback.LyEnt first = (KstCmsBase.Entities.Feeback.LyEnt)x;
                KstCmsBase.Entities.Feeback.LyEnt second = (KstCmsBase.Entities.Feeback.LyEnt)y;
                return first.LyTitle.CompareTo(second.LyTitle);
            }
        }

        private sealed class Lytime_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Feeback.LyEnt first = (KstCmsBase.Entities.Feeback.LyEnt)x;
                KstCmsBase.Entities.Feeback.LyEnt second = (KstCmsBase.Entities.Feeback.LyEnt)y;
                return first.LyTime.CompareTo(second.LyTime);
            }
        }

    }
    public class LyLbCollection : BaseCollection
    {
    }
}
