﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCmsBase.Collection.Wz
{
    public class WzCollection:BaseCollection
    {
        public enum SortFields { LbID, WzTitle, uTime, SortNo }
        public void Sort(SortFields SortField, bool isAscending)
        {
            switch (SortField)
            {
                case SortFields.LbID:
                    base.Sort(new LbID_Comparer());
                    break;
                case SortFields.WzTitle:
                    base.Sort(new WzTitle_Comparer());
                    break;
                case SortFields.uTime:
                    base.Sort(new uTime_Comparer());
                    break;
                case SortFields.SortNo:
                    base.Sort(new SortNo_Comparer());
                    break;
            }
            if (!isAscending) base.Reverse();
        }
        private sealed class LbID_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Wz.Wz_Ent first = (KstCmsBase.Entities.Wz.Wz_Ent)x;
                KstCmsBase.Entities.Wz.Wz_Ent second = (KstCmsBase.Entities.Wz.Wz_Ent)y;
                return first.LbID.CompareTo(second.LbID);
            }
        }
        private sealed class WzTitle_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Wz.Wz_Ent first = (KstCmsBase.Entities.Wz.Wz_Ent)x;
                KstCmsBase.Entities.Wz.Wz_Ent second = (KstCmsBase.Entities.Wz.Wz_Ent)y;
                return first.WzTitle.CompareTo(second.WzTitle);
            }
        }
        private sealed class uTime_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Wz.Wz_Ent first = (KstCmsBase.Entities.Wz.Wz_Ent)x;
                KstCmsBase.Entities.Wz.Wz_Ent second = (KstCmsBase.Entities.Wz.Wz_Ent)y;
                return first.uTime.CompareTo(second.uTime);
            }
        }

        private sealed class SortNo_Comparer : ImyComparer
        {
            public int Compare(object x, object y)
            {
                KstCmsBase.Entities.Wz.Wz_Ent first = (KstCmsBase.Entities.Wz.Wz_Ent)x;
                KstCmsBase.Entities.Wz.Wz_Ent second = (KstCmsBase.Entities.Wz.Wz_Ent)y;
                return first.SortNo.CompareTo(second.SortNo);
            }
        }

    }
    public class WzLBCollection : BaseCollection
    {

    }
}
