﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Web;
using System.Text.RegularExpressions;
using System.Web.UI.WebControls;

namespace KstCmsBase.Common
{
    public class Fucs
    {
        public static String GetMaxValue(String NumValue)
        {
            String Result = "1";
            if (!String.IsNullOrEmpty(NumValue))
            {
                Result = (Convert.ToInt32(NumValue) + 1).ToString();
            }
            return Result;
        }


        public static Boolean isNum(String str)
        {
            int num = 0;
            bool s = true;
            try
            {
                num = int.Parse(str);
            }
            catch
            {
                s = false;
            }
            return s;

        }

        public static String GetRootURI()
        {
            String AppPath = "";
            HttpContext HttpCurrent = HttpContext.Current;
            HttpRequest Req;
            if (HttpCurrent != null)
            {
                Req = HttpCurrent.Request;

                string UrlAuthority = Req.Url.GetLeftPart(UriPartial.Authority);
                if (Req.ApplicationPath == null || Req.ApplicationPath == "/")
                    //直接安装在   Web   站点   
                    // AppPath = UrlAuthority;
                    AppPath = "";
                else
                    //安装在虚拟子目录下   
                    // AppPath = UrlAuthority + Req.ApplicationPath;
                    AppPath = Req.ApplicationPath;
            }
            return AppPath;

        }
        /// <summary>
        /// 取随机数
        /// </summary>
        /// <returns></returns>
        public static String Rnd()
        {
            System.Random rand = new Random();
            int len = rand.Next(10, 10);
            char[] chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".ToCharArray();
            System.Text.StringBuilder myStr = new System.Text.StringBuilder();
            for (int iCount = 0; iCount < len; iCount++)
            {
                myStr.Append(chars[rand.Next(chars.Length)]);
            }
            String text = myStr.ToString();
            return text;
        }


        /// <summary>
        /// 过滤标记
        /// </summary>
        /// <param name="NoHTML">包括HTML，脚本，数据库关键字，特殊字符的源码 </param>
        /// <returns>已经去除标记后的文字</returns>
        public static String NoHTML(String Htmlstring)
        {
            if (Htmlstring == null)
            {
                return "";
            }
            else
            {
                //删除脚本
                Htmlstring = Regex.Replace(Htmlstring, @"<script[^>]*?>.*?</script>", "", RegexOptions.IgnoreCase);
                //删除HTML
                Htmlstring = Regex.Replace(Htmlstring, @"<(.[^>]*)>", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"([\r\n])[\s]+", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"-->", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"<!--.*", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(quot|#34);", "\"", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(amp|#38);", "&", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(lt|#60);", "<", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(gt|#62);", ">", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(nbsp|#160);", " ", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(iexcl|#161);", "\xa1", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(cent|#162);", "\xa2", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(pound|#163);", "\xa3", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&(copy|#169);", "\xa9", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, @"&#(\d+);", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "xp_cmdshell", "", RegexOptions.IgnoreCase);

                //删除与数据库相关的词
                Htmlstring = Regex.Replace(Htmlstring, "select", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "insert", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "delete from", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "count''", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "drop table", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "truncate", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "asc", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "mid", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "char", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "xp_cmdshell", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "exec master", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "net localgroup administrators", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "and", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "net user", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "or", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "net", "", RegexOptions.IgnoreCase);
                //Htmlstring = Regex.Replace(Htmlstring,"*", "", RegexOptions.IgnoreCase);
                //Htmlstring = Regex.Replace(Htmlstring,"-", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "delete", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "drop", "", RegexOptions.IgnoreCase);
                Htmlstring = Regex.Replace(Htmlstring, "script", "", RegexOptions.IgnoreCase);

                //特殊的字符
                Htmlstring = Htmlstring.Replace("<", "");
                Htmlstring = Htmlstring.Replace(">", "");
                Htmlstring = Htmlstring.Replace("*", "");
                Htmlstring = Htmlstring.Replace("=", "");
              //  Htmlstring = Htmlstring.Replace("-", "");
              //  Htmlstring = Htmlstring.Replace("?", "");
              // Htmlstring = Htmlstring.Replace(",", "");
              //  Htmlstring = Htmlstring.Replace("/", "");
                Htmlstring = Htmlstring.Replace(";", "");
                Htmlstring = Htmlstring.Replace("*/", "");
                Htmlstring = Htmlstring.Replace("\r\n", "");
                Htmlstring = HttpContext.Current.Server.HtmlEncode(Htmlstring).Trim();
                return Htmlstring;
            }
        }
/// <summary>
/// 用指定的字符替换目录名及文件里不能包含的非法字符
/// </summary>
/// <param name="str">被处理的字符串</param>
/// <param name="tagstr">替换成的字符串</param>
/// <returns></returns>
        public static string Replace_NoDirStr(string str,string tagstr)
        {
            return str.Replace(" ", tagstr).Replace("\\", tagstr).Replace("/", tagstr).Replace(":", tagstr).Replace("?", tagstr).Replace("\"", tagstr).Replace("<", tagstr).Replace(">", tagstr).Replace("|", tagstr).Replace("*", tagstr);
        }



        /// <summary>
        /// 测字符串是否含有非法字符(不为字母或数字的为非法字符)
        /// </summary>
        /// <param name="Str"></param>
        /// <returns>false 含有非法字符</returns>
        public static Boolean CheckEAndNoStr(String Str)
        {
            if (String.IsNullOrEmpty(Str))
                return true;
            Str = Str.ToLower();
            String S = "abcdefghijklmnopqrstuvwxyz1234567890";
            Boolean T = true;
            foreach (Char a in Str)
            {
                if (S.IndexOf(a) == -1)
                {
                    T = false;
                    break;
                }
            }
            return T;
        }


        public static String GetConfigValue(String Target)
        {
            String path = System.Web.HttpContext.Current.Server.MapPath("~/KstCMS.config");
            return GetConfigValue(Target, path);
        }

        public static String GetConfigValue(String Target, String XmlPath)
        {
            System.Xml.XmlDocument xdoc;
            if (System.Web.HttpContext.Current.Cache.Get("Config") != null)
                xdoc = (System.Xml.XmlDocument)System.Web.HttpContext.Current.Cache.Get("Config");
            else
            {
                xdoc = new System.Xml.XmlDocument();
                xdoc.Load(XmlPath);
                //System.Web.Caching.CacheDependency CaheDE = new System.Web.Caching.CacheDependency(XmlPath);
                System.Web.HttpContext.Current.Cache.Add("Config", xdoc, null, DateTime.Now.AddMinutes(60), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }
            System.Xml.XmlElement root = xdoc.DocumentElement;
            System.Xml.XmlNodeList elemList = root.GetElementsByTagName(Target);
            return elemList[0].InnerXml;
        }

        public static void CreateDir(string Path)
        {
            if (!System.IO.Directory.Exists(Path))
                System.IO.Directory.CreateDirectory(Path);
        }
        public static void DeleteDir(string Path)
        {
            if (System.IO.Directory.Exists(Path))
                System.IO.Directory.Delete(Path, true);
        }

        public static void DeleteFile(string FilePath)
        {
            try
            {
                if (System.IO.File.Exists(FilePath))
                    System.IO.File.Delete(FilePath);
            }
            finally
            {

            }
        }

    }
}
