﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI.WebControls;
using KstCmsBase.Collection.Product;
using KstCmsBase.Entities.Product;

namespace KstCmsBase.Common.HtmlControl
{
    public class ProLB_HtmlControls
    {

        private string _Link;
        private string _SiteId;
        private string _MenuId;
        private string _SysRootUrl;
 

        public ProLB_HtmlControls(string SiteId, string MenuId)
        {
            _SiteId = SiteId;
            _MenuId = MenuId;
        }
        public ProLB_HtmlControls(string SiteId,string MenuId,string LinkUrl)
        {
            _SiteId = SiteId;
            _MenuId = MenuId;
            _Link = LinkUrl;
            _SysRootUrl = KstCmsBase.Common.Fucs.GetRootURI();
    
        }

        /// <summary>
        /// 产品类别DropDownList 控件 Value为 lbid
        /// </summary>
        /// <param name="ParentID"></param>
        /// <param name="_DrpList"></param>
        public void Showdrp_LBID(int ParentID,ref DropDownList _DrpList)
        {
            
            ProLBCollection _ProLB_Items = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(_SiteId), Convert.ToInt32(_MenuId), ParentID, "LbID", "ParentID", "LbName");
            foreach (ProLB_Ent ProLB in _ProLB_Items)
            {
                
                ListItem item = new ListItem();
                item.Value = ProLB.LbID.ToString();
                string str = string.Empty;
                int depth = 0;
                Depth(item.Value, ref depth);//计算深度
                if (ProLB.ParentID != 0)
                {
                    for (int i = 1; i <= depth; i++)
                    {
                        str += "|--";
                    }
                }
                item.Text = "|--" + str + ProLB.LbName;
                _DrpList.Items.Add(item);
                Showdrp_LBID(ProLB.LbID, ref _DrpList);
            }
        }
        /// <summary>
        /// 产品类别DropDownList 控件 Value为 classid
        /// </summary>
        /// <param name="ParentID"></param>
        /// <param name="_DrpList"></param>
        public void ShowDrpProductLbID(int ParentID, ref DropDownList _DrpList)
        {
          /*  string CacheName = _DrpList.ClientID + _SiteId.ToString() + _MenuId.ToString();
            if (System.Web.HttpContext.Current.Cache.Get(CacheName) != null)
            {
                _DrpList = ((DropDownList)System.Web.HttpContext.Current.Cache.Get(CacheName));
                return;
            }
             */
            ProLBCollection _ProLB_Items = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(_SiteId), Convert.ToInt32(_MenuId), ParentID, "LbID", "ParentID", "LbName");
            foreach (ProLB_Ent ProLB in _ProLB_Items)
            {
                string _ClassId = string.Empty;
                KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(ProLB.LbID.ToString(), ref _ClassId);
                ListItem item = new ListItem();
                item.Value = _ClassId + ",";
                string str = string.Empty;
                int depth = 0;
                Depth(ProLB.LbID.ToString(), ref depth);//计算深度
                if (ProLB.ParentID != 0)
                {
                    for (int i = 1; i <= depth; i++)
                    {
                        str += "|--";
                    }
                }
                item.Text = "|--" + str + ProLB.LbName;
                _DrpList.Items.Add(item);
                ShowDrpProductLbID(ProLB.LbID, ref _DrpList);
            }
           // System.Web.HttpContext.Current.Cache.Add(CacheName, _DrpList, null, DateTime.Now.AddMinutes(Convert.ToDouble(KstCmsBase.Common.Fucs.GetConfigValue("cookietime"))), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
        }


        private void Depth(string CurrectLBID, ref int depth)
        {
            int Pid =KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(CurrectLBID), "ParentID").ParentID;
            if (Pid == 0)
            {
                return;
            }
            depth += 1;
            Depth(Pid.ToString(), ref depth);
        }

     


        /// <summary>
        /// 显示产品类别树
        /// </summary>
        public void ShowTREE(int ParentID,TreeNode ParentNode, ref TreeView _Mytree,bool ShowChxBOX=false)
        {
           
            ProLBCollection _ProLB_Items = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Convert.ToInt32(_SiteId), Convert.ToInt32(_MenuId), ParentID, "LbID", "ParentID", "LbName");
            foreach (ProLB_Ent item in _ProLB_Items)
            {
                string LbId = item.LbID.ToString();
                string LbName = item.LbName;
                string _ClassId = string.Empty;
                KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(LbId, ref _ClassId);
                TreeNode Node = new TreeNode();
                Node.Value = LbId;
                Node.Text = LbName;
                Node.NavigateUrl = _Link + "?LbID=" + LbId + "&ClassId=" + System.Web.HttpContext.Current.Server.UrlEncode(_ClassId) + "&LbName=" + System.Web.HttpContext.Current.Server.UrlEncode(LbName);
                if(KstCmsBase.DAL.Product.ProLB.HasSublb(LbId))
                    Node.ImageUrl =  _SysRootUrl+ "/KstCMS_Manager/images/menu/knowledge.gif";
                else
                    Node.ImageUrl = _SysRootUrl + "/KstCMS_Manager/images/menu/file_folder.gif";
                Node.Target = "main";
                Node.ShowCheckBox = ShowChxBOX;
                if (item.ParentID != 0)
                {
                    ParentNode.ChildNodes.Add(Node);     
                }
                else
                { 
                    _Mytree.Nodes.Add(Node);  
                }
                ShowTREE(item.LbID, Node, ref _Mytree, ShowChxBOX);  
            }
        }


    }
}
