﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.OleDb;
using KstCmsBase.Collection.Ad;
using KstCmsBase.Entities.Ad;

namespace KstCmsBase.DAL.Ad
{
    public class PicPlay
    {
        public static PicPlayCollection Get_PicPlayItems()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from PicPlay");
            PicPlayCollection Items = new PicPlayCollection();
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                PicPlay_Ent Item = new PicPlay_Ent();
                Item.AdID = Convert.ToInt32(dr["AdID"].ToString());
                Item.AdName = dr["AdName"].ToString();
                Item.PicH = Convert.ToInt32(dr["PicH"].ToString());
                Item.PicW = Convert.ToInt32(dr["PicW"].ToString());
                Item.ExeFile = dr["ExeFile"].ToString();
                Items.Add(Item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }
        public static PicPlay_Ent Get_PicPlayInfo(int AdID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from PicPlay where AdID=" + AdID);
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            PicPlay_Ent Item = new PicPlay_Ent();
            if (dr.Read())
            {
                Item.AdID = Convert.ToInt32(dr["AdID"].ToString());
                Item.AdName = dr["AdName"].ToString();
                Item.PicH = Convert.ToInt32(dr["PicH"].ToString());
                Item.PicW = Convert.ToInt32(dr["PicW"].ToString());
                Item.ExeFile = dr["ExeFile"].ToString();
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Item;
        }

        public static int PicPlay_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "PicPlay", Fields);
            db.Dispose();
            return r;
        }

        public static int PicPlay_Update(int Adid, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("PicPlay", "AdID", Adid, Data, Fields);
            db.Dispose();
            return r;
        }

        public static int PicPlay_Delete(int Adid)
        {
            Access db = new Access();
            PicCollection Pics = Get_PicPlay_PicList(Adid);
            foreach (PicEnt pic in Pics)
            {
                PicPlayList_Delete(pic.PicID);
            }
            int r = db.DataDelete("PicPlay", "AdID", Adid);
            db.Dispose();
            return r;
        }

        public static PicCollection Get_PicPlay_PicList(int Adid)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from PicPlayList where AdID={0} order by SortNo asc", Adid.ToString()));
            PicCollection Items = new PicCollection();
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                PicEnt Item = new PicEnt();
                Item.PicID = Convert.ToInt32(dr["PicID"].ToString());
                Item.AdTitle = dr["AdTitle"].ToString();
                Item.PicPath = dr["PicPath"].ToString();
                Item.LinkUrl = dr["LinkUrl"].ToString();
                Item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                Item.AdID = Adid;
                Items.Add(Item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }

        public static PicEnt Get_PicInfo(int PicId)
        {
            Access db = new Access();
            PicEnt Item = new PicEnt();
            string sql = db.Get_DbSQL(string.Format("from PicPlayList where PicID={0}", PicId.ToString()));
            OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                Item.PicID = Convert.ToInt32(dr["PicID"].ToString());
                Item.AdTitle = dr["AdTitle"].ToString();
                Item.PicPath = dr["PicPath"].ToString();
                Item.LinkUrl = dr["LinkUrl"].ToString();
                Item.SortNo = Convert.ToInt32(dr["SortNo"].ToString());
                Item.AdID = Convert.ToInt32(dr["AdID"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Item;
        }

        public static int Pic_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "PicPlayList", Fields);
            db.Dispose();
            return r;
        }

        public static int Pic_Update(int PicId, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("PicPlayList", "PicID", PicId, Data, Fields);
            db.Dispose();
            return r;
        }

        public static int PicPlayList_Delete(int PicID)
        {
            Access db = new Access();
            string PicPath = db.getFieldValue(string.Format("select PicPath from PicPlayList where PicID={0}", PicID.ToString()));
            KstCmsBase.Common.Fucs.DeleteFile(System.Web.HttpContext.Current.Server.MapPath(PicPath));
            int r = db.DataDelete("PicPlayList", "PicID", PicID);
            db.Dispose();
            return r;
        }

    }
}
