﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.DAL;
using KstCmsBase.Collection.Feeback;
using KstCmsBase.Entities.Feeback;

namespace KstCmsBase.DAL.Feeback
{
    public class Ly
    {
        #region --------留言-------------------------
        private static void GetField(DataRow Row, string FieldName, ref LyEnt item)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "LyID":
                    item.LyID = Convert.ToInt32(FieldValue);
                    break;
                case "LbID":
                    item.LbID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteID":
                    item.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "CName":
                    item.CName = FieldValue;
                    break;
                case "Attn":
                    item.Attn = FieldValue;
                    break;
                case "Tel":
                    item.Tel = FieldValue;
                    break;
                case "Fax":
                    item.Fax = FieldValue;
                    break;
                case "Email":
                    item.Email = FieldValue;
                    break;
                case "Addr":
                    item.Addr = FieldValue;
                    break;
                case "LyTitle":
                    item.LyTitle = FieldValue;
                    break;
                case "LyContent":
                    item.LyContent = FieldValue;
                    break;
                case "ReContent":
                    item.ReContent = FieldValue;
                    break;
                case "LyTime":
                    item.LyTime = Convert.ToDateTime(FieldValue);
                    break;
                case "ReTime":
                    if(!string.IsNullOrEmpty(FieldValue))
                        item.ReTime = Convert.ToDateTime(FieldValue);
                    break;
                case "IP":
                    item.IP = FieldValue;
                    break;
            }
        }

        public static LyListCollection GetLyList(int SiteId, int LbId,params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from LyINFO where SiteID={0}", SiteId.ToString()), Fields);
            if (LbId != 0)
                sql += " and LbID=" + LbId;
            sql += " order by LyTime desc";
            LyListCollection items = new LyListCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                LyEnt item = new LyEnt();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return items;


        }

        public static LyEnt Get_LyInfo(int LyID, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from LyINFO where LyID={0}", LyID), Fields);
            LyEnt item = new LyEnt();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;

        }

        public static int ClientLy(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "LyINFO", Fields);
            db.Dispose();
            return r;
        }

        public static int Rely(int LyID, string Content)
        {
            Access db = new Access();
            string[] data = new string[] { Content, DateTime.Now.ToString() };
            int r = db.DataUpdate("LyINFO", "LyID", LyID, data, "ReContent", "ReTime");
            db.Dispose();
            return r;
        }

        public static int Lydelete(int LyID)
        {
            Access db = new Access();
            int r = db.DataDelete("LyINFO", "LyID", LyID);
            db.Dispose();
            return r;
        }
        #endregion

        public static LyLbCollection Get_LyLBitems()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from LyLB");
            LyLbCollection items = new LyLbCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                LyLbEnt item = new LyLbEnt();
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.LbName = dr["LbName"].ToString();
                item.isSys = Convert.ToInt32(dr["IsSys"].ToString());
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }
        public static LyLbEnt Get_LyLbInfo(int Lbid)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from LyLB where LbID={0}", Lbid.ToString()));
            LyLbEnt item = new LyLbEnt();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.LbID = Convert.ToInt32(dr["LbID"].ToString());
                item.LbName = dr["LbName"].ToString();
                item.isSys = Convert.ToInt32(dr["IsSys"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int Lylb_Insert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "LyLB", Fields);
            db.Dispose();
            return r;
        }

        public static int Lylb_Update(int Lbid, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("LyLB", "LbID", Lbid, data, Fields);
            db.Dispose();
            return r;
        }
        public static int Lylb_delete(int lbid)
        {
            Access db = new Access();
            db.DataDelete("LyINFO", "LbID", lbid);
            int r = db.DataDelete("LyLB", "LbID", lbid);
            db.Dispose();
            return r;
        }
    }
}
