﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection;
using KstCmsBase.Collection.Product;
using KstCmsBase.Entities;
using KstCmsBase.Entities.Product;

namespace KstCmsBase.DAL.Product
{
    public class ProductType
    {
        public static ProductTypeCollection GetProductTypeList()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from ProductType");
            ProductTypeCollection items = new ProductTypeCollection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                ProductType_Ent item = new ProductType_Ent();
                item.TypeID = Convert.ToInt32(row["TypeID"].ToString());
                item.TypeName = row["TypeName"].ToString();
                item.IsSys = Convert.ToInt32(row["IsSys"].ToString());
                item.Field1List = GetField1List(item.TypeID.ToString());
                item.Field2List = GetField2List(item.TypeID.ToString());
                items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        public static ProductType_Ent GetProductTypeInfo(string TypeID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductType where TypeID={0}", TypeID));
            ProductType_Ent item = new ProductType_Ent();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.TypeID = Convert.ToInt32(dr["TypeID"].ToString());
                item.TypeName = dr["TypeName"].ToString();
                item.Field1List = GetField1List(TypeID);
                item.Field2List = GetField2List(TypeID);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static ProductField1Collection GetField1List(string TypeID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductField1 where TypeID={0}", TypeID));
            ProductField1Collection Items = new ProductField1Collection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Field1_Ent item = new Field1_Ent();
                item.FieldId = Convert.ToInt32(row["FieldId"].ToString());
                item.TypeID = Convert.ToInt32(row["TypeID"].ToString());
                item.FieldName = row["FieldName"].ToString();
                item.FieldValue = row["FieldValue"].ToString();
                item.InputType = Convert.ToInt32(row["InputType"].ToString());
                item.SortNo = Convert.ToInt32(row["SortNo"].ToString());
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }


        public static ProductField2Collection GetField2List(string TypeID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from ProductField2 where TypeID={0}", TypeID));
            ProductField2Collection Items = new ProductField2Collection();
            DataSet dsData = db.ExecuteDataSet(sql);
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Field2_Ent item = new Field2_Ent();
                item.FieldId = Convert.ToInt32(row["FieldId"].ToString());
                item.TypeID = Convert.ToInt32(row["TypeID"].ToString());
                item.FieldName = row["FieldName"].ToString();
                item.FieldValue = row["FieldValue"].ToString();
                item.SortNo = Convert.ToInt32(row["SortNo"].ToString());
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static int ProductTypeInsert(string[] FieldValue,params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldValue, "ProductType", Fields);
            db.Dispose();
            return r;
        }

        public static int ProductTypeUpdate(string[] FieldValue,int loadID, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("ProductType", "TypeID", loadID, FieldValue, Fields);
            db.Dispose();
            return r;
        }

        public static int Field1_Insert(string[] FieldValue, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldValue, "ProductField1", Fields);
            db.Dispose();
            return r;
        }

        public static int Field1_Update(string[] FieldValue, int loadID, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("ProductField1", "FieldId", loadID, FieldValue, Fields);
            db.Dispose();
            return r;
        }


        public static int Field2_Insert(string[] FieldValue, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldValue, "ProductField2", Fields);
            db.Dispose();
            return r;
        }

        public static int Field2_Update(string[] FieldValue, int loadID, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("ProductField2", "FieldId", loadID, FieldValue, Fields);
            db.Dispose();
            return r;
        }

        public static int ProductTypeDelete(string TypeId)
        {
            Access db = new Access();
            int r = db.DataDelete("ProductType", "TypeID", Convert.ToInt32(TypeId));
            db.ExecuteSql(string.Format("delete from ProductField1 where TypeID={0}", TypeId));
            db.ExecuteSql(string.Format("delete from ProductField2 where TypeID={0}", TypeId));
            db.Dispose();
            return r;
        }

        public static int Field1_Delete(string FieldId)
        {
            Access db = new Access();
            int r = db.DataDelete("ProductField1", "FieldId", Convert.ToInt32(FieldId));
            db.Dispose();
            return r;
        }

        public static int Field2_Delete(string FieldId)
        {
            Access db = new Access();
            int r = db.DataDelete("ProductField2", "FieldId", Convert.ToInt32(FieldId));
            db.Dispose();
            return r;
        }




    }
}
