﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.Common;
using KstCmsBase.Entities;
using KstCmsBase.Collection;
namespace KstCmsBase.DAL
{
    public class SysMenu
    {
        #region Methods

        /// <summary>
        /// 取系统主菜单集
        /// </summary>
        /// <returns></returns>
        public static SysMenuCollection Get_SysMasterMenu()
        {
            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SYS_MENU order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                SysMenuEntity item = new SysMenuEntity();
                item.MENU_ID = row["MENU_ID"].ToString();
                item.MENU_NAME = row["MENU_NAME"].ToString();
                item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                item.MENU_CODE = row["MENU_URL"].ToString();
                items.Add(item);

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        /// <summary>
        /// 验证当前用户使用菜单权限，有权限则显示菜单.
        /// </summary>
        /// <param name="CurrentUserId"></param>
        /// <returns></returns>
        public static SysMenuCollection Get_SysMasterMenu(string CurrentUserId)
        {
            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SYS_MENU order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Boolean ShowItem = false;
                if (CurrentUserId != "")
                {
                    string thisMenuId = row["MENU_ID"].ToString();
                    if (isShowMenu(CurrentUserId, thisMenuId))
                        ShowItem = true;
                }
                if (ShowItem)
                {
                    SysMenuEntity item = new SysMenuEntity();
                    item.MENU_ID = row["MENU_ID"].ToString();
                    item.MENU_NAME = row["MENU_NAME"].ToString();
                    item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                    item.MENU_CODE = row["MENU_URL"].ToString();
                    items.Add(item);

                }
            }

            dsData.Dispose();
            db.Dispose();
            return items;
        }

        public static SysMenuCollection Get_ModelMenu(string MasterMenuId)
        {

            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SUB_MENU where MENU_ID like '" + MasterMenuId + "__' order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                SysMenuEntity item = new SysMenuEntity();
                item.MENU_ID = row["MENU_ID"].ToString();
                item.MENU_NAME = row["MENU_NAME"].ToString();
                item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                item.MENU_CODE = row["MENU_CODE"].ToString();

                items.Add(item);

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        /// <summary>
        /// 验证当前用户使用菜单权限，有权限则显示菜单.
        /// </summary>
        /// <param name="MasterMenuId"></param>
        /// <param name="CurrentUserId"></param>
        /// <returns></returns>
        public static SysMenuCollection Get_ModelMenu(string MasterMenuId, string CurrentUserId)
        {
            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SUB_MENU where MENU_ID like '" + MasterMenuId + "__' order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Boolean ShowItem = false;
                if (CurrentUserId != "")
                {
                    string thisMenuId = row["MENU_ID"].ToString();
                    if (isShowMenu(CurrentUserId, thisMenuId))
                        ShowItem = true;
                }
                if (ShowItem)
                {
                    SysMenuEntity item = new SysMenuEntity();
                    item.MENU_ID = row["MENU_ID"].ToString();
                    item.MENU_NAME = row["MENU_NAME"].ToString();
                    item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                    item.MENU_CODE = row["MENU_CODE"].ToString();
                    items.Add(item);
                }

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }


        public static SysMenuCollection Get_SubMenu(string ParentMenuId)
        {
            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SUB_MENU where MENU_ID like '" + ParentMenuId + "__' order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                SysMenuEntity item = new SysMenuEntity();
                item.MENU_ID = row["MENU_ID"].ToString();
                item.MENU_NAME = row["MENU_NAME"].ToString();
                item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                item.MENU_CODE = row["MENU_CODE"].ToString();

                items.Add(item);

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }
        /// <summary>
        /// 需要权限验证时使用
        /// </summary>
        /// <param name="ParentMenuId"></param>
        /// <param name="CurrentUserId"></param>
        /// <returns></returns>
        public static SysMenuCollection Get_SubMenu(string ParentMenuId, string CurrentUserId)
        {
            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SUB_MENU where MENU_ID like '" + ParentMenuId + "__' order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                Boolean ShowItem = false;
                if (CurrentUserId != "")
                {
                    string thisMenuId = row["MENU_ID"].ToString();
                    if (isShowMenu(CurrentUserId, thisMenuId))
                        ShowItem = true;
                }
                if (ShowItem)
                {
                    SysMenuEntity item = new SysMenuEntity();
                    item.MENU_ID = row["MENU_ID"].ToString();
                    item.MENU_NAME = row["MENU_NAME"].ToString();
                    item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                    item.MENU_CODE = row["MENU_CODE"].ToString();

                    items.Add(item);
                }

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }

        public static SysMenuCollection Get_AllSubMenu()
        {
            Access db = new Access();
            DataSet dsData = db.ExecuteDataSet("select * from SUB_MENU order by MENU_ID asc");
            SysMenuCollection items = new SysMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                SysMenuEntity item = new SysMenuEntity();
                item.MENU_ID = row["MENU_ID"].ToString();
                item.MENU_NAME = row["MENU_NAME"].ToString();
                item.MENU_IMAGE = row["MENU_IMAGE"].ToString();
                item.MENU_CODE = row["MENU_CODE"].ToString();

                items.Add(item);

            }
            dsData.Dispose();
            db.Dispose();
            return items;
        }



        #region 主菜单操作
        public static int SysMenu_Insert(string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldsValue, "Sys_Menu", FieldNames);
            db.Dispose();
            return r;
        }

        public static int SysMenu_Update(string LoadID, string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("Sys_Menu", "MENU_ID", LoadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }

        public static int SysMenu_Delete(string LoadID)
        {
            Access db = new Access();
            int r = db.DataDelete("Sys_Menu", "MENU_ID", LoadID);
            if (r > 0)
            {
                string sql = "delete from SUB_MENU where MENU_ID like '" + LoadID + "%'";
                r += db.ExecuteSql(sql);
            }
            db.Dispose();
            return r;
        }

        #endregion

        #region 子菜单操作
        public static int SubMenu_Insert(string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldsValue, "Sub_Menu", FieldNames);
            db.Dispose();
            return r;
        }
        public static int SubMenu_Update(string loadID,string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("Sub_Menu", "MENU_ID", loadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }

        public static int SubMenu_Delete(string MenuId)
        {
            Access db = new Access();
            int r = db.DataDelete("Sub_Menu", "MENU_ID", MenuId);
            if (r > 0)
            {
                string sql = "delete from SUB_MENU where MENU_ID like '" + MenuId + "%'";
                r += db.ExecuteSql(sql);
            }
            db.Dispose();
            return r;


        }
        /// <summary>
        /// 根据用户ID决定是否显示MENU,如果用户是admin 不管它属那个角色都有所有显示所有的菜单
        /// </summary>
        /// <param name="CurrentUserId"></param>
        /// <param name="MenuId"></param>
        /// <returns>返回TRUE 表示有权限</returns>
        public static Boolean isShowMenu(string CurrentUserId, string MenuId)
        {
            UsersEntity urs = Users.Get_UserInfo(CurrentUserId);
            if (urs.isAdmin == 1)
                return true;
            Boolean isTrue = false;
            ///取用户所属角色ID,用户可能是多个角色，即多个角色ID.
            string[] RoleId = urs.UserRole.Split(',');
            for (int n = 0; n < RoleId.Length; n++)
            {
                if (!string.IsNullOrEmpty(RoleId[n].ToString()))
                {

                    int rid = Convert.ToInt32(RoleId[n].ToString());
                    string RunCode = (Role.Get_RoleInfo(rid)).RunCode;///取角色对应的RunCode
                    string[] ArrayRunCode = RunCode.Split(',');
                    for (int i = 0; i < ArrayRunCode.Length; i++)
                    {
                        string InRunCodeMenuId = ArrayRunCode[i].ToString().Trim();
                        if (MenuId == InRunCodeMenuId)
                        {
                            isTrue = true;
                            break;
                        }
                    }
                }
            }
            return isTrue;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="RoleId"></param>
        /// <param name="MenuId"></param>
        /// <returns></returns>
        public static Boolean isShowMenu(string MenuId, params string[] RoleId)
        {
            Boolean isTrue = false;
            for (int n = 0; n < RoleId.Length; n++)
            {
                int rid = Convert.ToInt32(RoleId[n].ToString());
                string RunCode = (Role.Get_RoleInfo(rid)).RunCode;///取角色对应的RunCode
                string[] ArrayRunCode = RunCode.Split(',');
                for (int i = 0; i < ArrayRunCode.Length; i++)
                {
                    string InRunCodeMenuId = ArrayRunCode[i].ToString().Trim();
                    if (MenuId == InRunCodeMenuId)
                    {
                        isTrue = true;
                        break;
                    }
                }
            }
            return isTrue;
        }

        public static Boolean isShowMenu(int RoleID, string MenuId)
        {
            Boolean isTrue = false;

            string RunCode = (Role.Get_RoleInfo(RoleID)).RunCode;///取角色对应的RunCode
            string[] ArrayRunCode = RunCode.Split(',');
            for (int i = 0; i < ArrayRunCode.Length; i++)
            {
                string InRunCodeMenuId = ArrayRunCode[i].ToString().Trim();
                if (MenuId == InRunCodeMenuId)
                {
                    isTrue = true;
                    break;
                }
            }

            return isTrue;
        }




        #endregion

        #endregion
    }

       
}