﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Entities.Tag;
using KstCmsBase.Collection.Tag;
using KstCmsBase.DAL;

namespace KstCmsBase.DAL.Tag
{
    public class SysTAG
    {
        public static SysTAGCollection GetSysTagItems(int SysLBID=0)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from SysTAG where TagLBID={0}", SysLBID.ToString()));
            if (SysLBID == 0)
                sql = db.Get_DbSQL("from SysTAG");
            SysTAGCollection items = new SysTAGCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                SysTAG_ent item = new SysTAG_ent();
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLBID = Convert.ToInt32(dr["TagLBID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.SysTAG = dr["SysTAG"].ToString();
                item.TagDESC = dr["TagDESC"].ToString();
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }

        public static SysTAG_ent GetSystagInfo(int TagID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from SysTAG where TagID={0}", TagID.ToString()));
            SysTAG_ent item = new SysTAG_ent();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.TagID = Convert.ToInt32(dr["TagID"].ToString());
                item.TagLBID = Convert.ToInt32(dr["TagLBID"].ToString());
                item.TagName = dr["TagName"].ToString();
                item.SysTAG = dr["SysTAG"].ToString();
                item.TagDESC = dr["TagDESC"].ToString();
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int SysTAG_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "SysTAG", Fields);
            db.Dispose();
            return r;
        }
        public static int SysTAG_Update(int TagID, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("SysTAG", "TagID", TagID, Data, Fields);
            db.Dispose();
            return r;
        }

        public static int SysTAG_Delete(int TagID)
        {
            Access db = new Access();
            int r = db.DataDelete("SysTAG", "TagID", TagID);
            db.Dispose();
            return r;
        }


        ///类别
        public static SysTAGLBCollection GetSysTAGLB_Items()
        {
            Access db = new Access();
            string sql = db.Get_DbSQL("from SysTAGLB");
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            SysTAGLBCollection items = new SysTAGLBCollection();
            while (dr.Read())
            {
                SysTAGLB_ent item = new SysTAGLB_ent();
                item.SysLBID = Convert.ToInt32(dr["SysLBID"].ToString());
                item.LbNAME = dr["LbNAME"].ToString();
                items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return items;
        }

        public static SysTAGLB_ent GetSysTAGLBInfo(int SysLBID)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from SysTAGLB where SysLBID={0}", SysLBID.ToString()));
            SysTAGLB_ent item = new SysTAGLB_ent();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                item.SysLBID = Convert.ToInt32(dr["SysLBID"].ToString());
                item.LbNAME = dr["LbNAME"].ToString();
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return item;
        }

        public static int SysTAGLB_Insert(string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(Data, "SysTAGLB", Fields);
            db.Dispose();
            return r;
        }

        public static int SysTAGLB_Update(int SysLBID, string[] Data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("SysTAGLB", "SysLBID", SysLBID, Data, Fields);
            db.Dispose();
            return r;
        }

        public static int SysTAGLB_delete(int SysLBID)
        {
            SysTAGCollection items = GetSysTagItems(SysLBID);
            if (items.Count > 0)
            {
                throw new Exception("操作错误！,些类别存在系统标签不能直接删除！");
            }
            Access db = new Access();
            int r = db.DataDelete("SysTAGLB", "SysLBID", SysLBID);
            db.Dispose();
            return r;
        }
    }
}
