﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Collection;
using KstCmsBase.Entities;

namespace KstCmsBase.DAL
{
    public class Templates
    {
        public enum TempType { HomePage, LmPage, uPage, ProList, ProContent, WzList, WzContent, PicList, PicContent, DownList, DownContent, Link, SiteMap };

        public static TempCollection GetTemplatesItems(TempType TType)
        {
            string sql = string.Empty;
            Access db = new Access();
            switch (TType)
            {
                case TempType.HomePage:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=0");
                    break;
                case TempType.LmPage:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=1");
                    break;
                case TempType.uPage:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=2");
                    break;
                case TempType.ProList:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=3");
                    break;
                case TempType.ProContent:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=4");
                    break;
                case TempType.WzList:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=5");
                    break;
                case TempType.WzContent:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=6");
                    break;
                case TempType.PicList:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=7");
                    break;
                case TempType.PicContent:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=8");
                    break;
                case TempType.DownList:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=9");
                    break;
                case TempType.DownContent:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=10");
                    break;
                case TempType.Link:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=11");
                    break;
                case TempType.SiteMap:
                    sql = db.Get_DbSQL("from WebTEMP where TempType=12");
                    break;
            }
            TempCollection Items = new TempCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                Template_Ent item = new Template_Ent();
                item.TempID = Convert.ToInt32(dr["TempID"].ToString());
                item.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                item.TempName = dr["TempName"].ToString();
                item.TempContent = dr["TempContent"].ToString();
                item.TempType = Convert.ToInt32(dr["TempType"].ToString());
                item.DefaultAct = Convert.ToInt32(dr["DefaultAct"].ToString());
                Items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }
        public static TempCollection GetTemplatesItems(TempType TType,int SiteId)
        {
            string sql = string.Empty;
            Access db = new Access();
            switch (TType)
            {
                case TempType.HomePage:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=0 and SiteID={0}",SiteId.ToString()));
                    break;
                case TempType.LmPage:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=1 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.uPage:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=2 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.ProList:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=3 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.ProContent:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=4 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.WzList:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=5 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.WzContent:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=6 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.PicList:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=7 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.PicContent:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=8 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.DownList:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=9 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.DownContent:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=10 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.Link:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=11 and SiteID={0}", SiteId.ToString()));
                    break;
                case TempType.SiteMap:
                    sql = db.Get_DbSQL(string.Format("from WebTEMP where TempType=12 and SiteID={0}", SiteId.ToString()));
                    break;
            }
            TempCollection Items = new TempCollection();
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            while (dr.Read())
            {
                Template_Ent item = new Template_Ent();
                item.TempID = Convert.ToInt32(dr["TempID"].ToString());
                item.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                item.TempName = dr["TempName"].ToString();
                item.TempContent = dr["TempContent"].ToString();
                item.TempType = Convert.ToInt32(dr["TempType"].ToString());
                item.DefaultAct = Convert.ToInt32(dr["DefaultAct"].ToString());
                Items.Add(item);
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Items;
        }


        public static Template_Ent GetTemplate(string TempId)
        {
            Access db = new Access();
            Template_Ent Template = new Template_Ent();
            string sql = db.Get_DbSQL(string.Format("from WebTEMP where TempID={0}", TempId));
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                Template.TempID = Convert.ToInt32(dr["TempID"].ToString());
                Template.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                Template.TempName = dr["TempName"].ToString();
                Template.TempContent = dr["TempContent"].ToString();
                Template.TempType = Convert.ToInt32(dr["TempType"].ToString());
                Template.DefaultAct = Convert.ToInt32(dr["DefaultAct"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Template;
        }

        public static Template_Ent GetDefaultTemplate(TempType TType,int SiteId)
        {
            Access db = new Access();
            Template_Ent Template = new Template_Ent();
            string sql = db.Get_DbSQL(Get_DefaultSQL(TType, SiteId.ToString()));
            System.Data.OleDb.OleDbDataReader dr = db.ExecuteDataReader(sql);
            if (dr.Read())
            {
                Template.TempID = Convert.ToInt32(dr["TempID"].ToString());
                Template.SiteID = Convert.ToInt32(dr["SiteID"].ToString());
                Template.TempName = dr["TempName"].ToString();
                Template.TempContent = dr["TempContent"].ToString();
                Template.TempType = Convert.ToInt32(dr["TempType"].ToString());
                Template.DefaultAct = Convert.ToInt32(dr["DefaultAct"].ToString());
            }
            dr.Close();
            dr.Dispose();
            db.Dispose();
            return Template;
        }


        public static int TempInsert(string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataInsert(data, "WebTEMP", Fields);
            db.Dispose();
            return r;
        }

        public static int TempUpdate(int loadID, string[] data, params string[] Fields)
        {
            Access db = new Access();
            int r = db.DataUpdate("WebTEMP", "TempID", loadID, data, Fields);
            db.Dispose();
            return r;
        }

        public static int TempDelete(string TempId)
        {
            Access db = new Access();
            int DefalutAc = Convert.ToInt32(db.getFieldValue(string.Format("select DefaultAct from WebTEMP where TempID={0}", TempId)));
            if (DefalutAc == 1)
            {
                db.Dispose();
                throw new Exception("操作错误，禁止删除系统默认模板！");
            }
            int r = db.DataDelete("WebTEMP", "TempID", Convert.ToInt32(TempId));
            db.Dispose();
            return r;
        }

        public static int SetTempDefalutAct(string TempId, TempType TType)
        {
            Access db = new Access();
            string SiteId = db.getFieldValue(string.Format("select SiteID from WebTEMP where TempID={0}", TempId));
            string sql = string.Empty;
            switch (TType)
            {
                case TempType.HomePage:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=0", SiteId);
                    break;
                case TempType.LmPage:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=1", SiteId);
                    break;
                case TempType.uPage:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=2", SiteId);
                    break;
                case TempType.ProList:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=3", SiteId);
                    break;
                case TempType.ProContent:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=4", SiteId);
                    break;
                case TempType.WzList:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=5", SiteId);
                    break;
                case TempType.WzContent:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=6", SiteId);
                    break;
                case TempType.PicList:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=7", SiteId);
                    break;
                case TempType.PicContent:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=8", SiteId);
                    break;
                case TempType.DownList:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=9", SiteId);
                    break;
                case TempType.DownContent:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=10", SiteId);
                    break;
                case TempType.Link:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=11", SiteId);
                    break;
                case TempType.SiteMap:
                    sql = string.Format("update WebTEMP set DefaultAct=0 where SiteID={0} and TempType=12", SiteId);
                    break;
            }
            System.Data.OleDb.OleDbCommand cmd = new System.Data.OleDb.OleDbCommand(sql, db.dbconn);
            cmd.ExecuteNonQuery();
            cmd.Dispose();
            string[] data = new string[] { "1" };
            int r = db.DataUpdate("WebTEMP", "TempID", Convert.ToInt32(TempId), data, "DefaultAct");
            db.Dispose();
            return r;
        }


        private static string Get_DefaultSQL(TempType TType,string SiteId)
        {
            string sql = string.Empty;
            switch (TType)
            {
                case TempType.HomePage:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=0 and SiteID={0}", SiteId);
                    break;
                case TempType.LmPage:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=1 and SiteID={0}", SiteId);
                    break;
                case TempType.uPage:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=2 and SiteID={0}", SiteId);
                    break;
                case TempType.ProList:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=3 and SiteID={0}", SiteId);
                    break;
                case TempType.ProContent:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=4 and SiteID={0}", SiteId);
                    break;
                case TempType.WzList:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=5 and SiteID={0}", SiteId);
                    break;
                case TempType.WzContent:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=6 and SiteID={0}", SiteId);
                    break;
                case TempType.PicList:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=7 and SiteID={0}", SiteId);
                    break;
                case TempType.PicContent:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=8 and SiteID={0}", SiteId);
                    break;
                case TempType.DownList:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=9 and SiteID={0}", SiteId);
                    break;
                case TempType.DownContent:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=10 and SiteID={0}", SiteId);
                    break;
                case TempType.Link:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=11 and SiteID={0}", SiteId);
                    break;
                case TempType.SiteMap:
                    sql = string.Format("from WebTEMP where DefaultAct=1 and TempType=12 and SiteID={0}", SiteId);
                    break;
            }
            return sql;
        }



    }
}
