﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using KstCmsBase.Entities;
using KstCmsBase.Collection;

namespace KstCmsBase.DAL
{
    public class WebMenu
    {
        
        private static void GetField(DataRow Row, string FieldName, ref WebMenu_ent WebMenu)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "MenuID":
                    WebMenu.MenuID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteID":
                    WebMenu.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "MenuName":
                    WebMenu.MenuName = FieldValue;
                    break;
                case "MenuDiy":
                    WebMenu.MenuDiy = FieldValue;
                    break;
                case "GoUrl":
                    WebMenu.GoUrl = FieldValue;
                    break;
                case "IsOutUrl":
                    WebMenu.IsOutUrl = Convert.ToInt32(FieldValue);
                    break;
                case "GoLmID":
                    WebMenu.GoLmID = Convert.ToInt32(FieldValue);
                    break;
                case "MateKey":
                    WebMenu.MateKey = FieldValue;
                    break;
                case "MateDesc":
                    WebMenu.MateDesc = FieldValue;
                    break;
                case "Act":
                    WebMenu.Act = Convert.ToInt32(FieldValue);
                    break;
                case "AttRib":
                    WebMenu.AttRib = Convert.ToInt32(FieldValue);
                    break;
                case "SortNo":
                    WebMenu.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "TempID":
                    WebMenu.TempID = Convert.ToInt32(FieldValue);
                    break;
                case "IsShow":
                    WebMenu.IsShow = Convert.ToInt32(FieldValue);
                    break;

            }

        }

        public static WebMenuCollection Get_MenuList(int SiteID,params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebMenu where SiteID={0} order by SortNo asc",SiteID), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebMenuCollection Items = new WebMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebMenu_ent item = new WebMenu_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static WebMenuCollection Get_MenuList(int SiteID,bool IsShow, params string[] Fields)
        {
            Access db = new Access();
            string sql = string.Empty;
            if(IsShow)
                sql = db.Get_DbSQL(string.Format("from WebMenu where SiteID={0} and IsShow=1 order by SortNo asc", SiteID), Fields);
            else
                sql = db.Get_DbSQL(string.Format("from WebMenu where SiteID={0} and IsShow=0 order by SortNo asc", SiteID), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebMenuCollection Items = new WebMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebMenu_ent item = new WebMenu_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static WebMenuCollection Get_MenuList(int SiteID,int Action, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebMenu where SiteID={0} and Act={1} order by SortNo asc", SiteID, Action), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebMenuCollection Items = new WebMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebMenu_ent item = new WebMenu_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }

        public static WebMenuCollection Get_MenuList(int SiteID, int Action,int Attrib, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebMenu where SiteID={0} and Act={1} and AttRib={2} and IsOutUrl<>1 order by SortNo asc", SiteID, Action, Attrib.ToString()), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebMenuCollection Items = new WebMenuCollection();
            foreach (DataRow row in dsData.Tables[0].Rows)
            {
                WebMenu_ent item = new WebMenu_ent();
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(row, FieldName, ref item);
                }
                Items.Add(item);
            }
            dsData.Dispose();
            db.Dispose();
            return Items;
        }


        public static WebMenu_ent Get_WebMenuInfo(int MenuId, params string[] Fields)
        {
            Access db = new Access();
            string sql = db.Get_DbSQL(string.Format("from WebMenu where MenuId={0}", MenuId), Fields);
            DataSet dsData = db.ExecuteDataSet(sql);
            WebMenu_ent item = new WebMenu_ent();
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string FieldName = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], FieldName, ref item);
                }
            }
            dsData.Dispose();
            db.Dispose();
            return item;
        }

        public static int Insert(string[] FieldsValue, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataInsert(FieldsValue, "WebMenu", FieldNames);
            db.Dispose();
            return r;
        }

        public static int Update(string[] FieldsValue, int LoadID, params string[] FieldNames)
        {
            Access db = new Access();
            int r = db.DataUpdate("WebMenu", "MenuId", LoadID, FieldsValue, FieldNames);
            db.Dispose();
            return r;
        }

        public static int Delete(string LoadID)
        {
            KstCmsBase.Collection.WebLmCollection WebLM = KstCmsBase.DAL.WebLM.Get_LMList(Convert.ToInt32(LoadID), "LmID");
            if (WebLM.Count > 0)
            {
                throw new Exception("对不起，该项导航存在下属栏目，不能直接删除！");

            }
            
            Access db = new Access();
            if (Convert.ToInt32(db.getFieldValue(string.Format("select count(*) as id from ProductLB where MenuID={0}", LoadID))) > 0)
            {
                db.Dispose();
                throw new Exception("对不起，该项导航属产品栏目，它已存在产品分类信息，不能直接删除！");
            }
            if (Convert.ToInt32(db.getFieldValue(string.Format("select count(*) as id from WzLB where MenuID={0}", LoadID))) > 0)
            {
                db.Dispose();
                throw new Exception("对不起，该项导航属文章栏目，它已存在文章分类信息，不能直接删除！");
            }
            int r = db.DataDelete("WebMenu", "MenuId", Convert.ToInt32(LoadID));
            db.Dispose();
            return r;
        }


    }
}
