﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCmsBase.WebPage
{
    public class BasePage : System.Web.UI.Page
    {
        #region Properties
        protected string TopTitle { get { return CssAndCopyRight.TopTitle; } }
        protected string WebTitle { get { return CssAndCopyRight.WebTitle; } }
        protected string ComName { get { return CssAndCopyRight.ComName; } }
        protected string UserSoftName { get { return CssAndCopyRight.UserSoftName; } }
        protected string SoftUrl { get { return "http://www.ygdns.cn"; } }
        protected KstCmsBase.Entities.WebSite_ent DefaultSite
        {
            get
            {
                return KstCmsBase.DAL.WebSite.Get_DefaultSite();
            }
        }
        protected int CacheTime
        {
            get
            {
                return Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("cachetime"));
            }
        }

        protected int CookieTime
        {
            get
            {
                return Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("cookietime"));
            }
        }

        protected string SysRootUrl
        {
            get
            {
                string RootUrl = string.Empty;
                if (System.Web.HttpContext.Current.Cache.Get("RootUrl") != null)
                    RootUrl = System.Web.HttpContext.Current.Cache.Get("RootUrl").ToString();
                else
                {
                    RootUrl = KstCmsBase.Common.Fucs.GetRootURI();
                    System.Web.HttpContext.Current.Cache.Add("RootUrl", RootUrl, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                }
                return RootUrl;
            }
        }

        protected string UpLoadPath
        {
            get
            {
                string str = string.Empty;
                if (Read_Cache("uploadpath") != null)
                    str = Read_Cache("uploadpath").ToString();
                else
                {
                    str = KstCmsBase.Common.Fucs.GetConfigValue("uploadpath");
                    Set_Cache("uploadpath", str);
                }
                return str;

            }
        }

        protected int DirType
        {
            get
            {
                string str = string.Empty;
                if (Read_Cache("dirtype") != null)
                    str = Read_Cache("dirtype").ToString();
                else
                {
                    str = KstCmsBase.Common.Fucs.GetConfigValue("dirtype");
                    Set_Cache("dirtype", str);
                }
                return Convert.ToInt32(str);
            }
        }

        protected int MaxAttachSize
        {
            get
            {
                string str = string.Empty;
                if (Read_Cache("maxattachsize") != null)
                    str = Read_Cache("maxattachsize").ToString();
                else
                {
                    str = KstCmsBase.Common.Fucs.GetConfigValue("maxattachsize");
                    Set_Cache("maxattachsize", str);
                }
                return Convert.ToInt32(str);
            }
        }

        protected string UpExt
        {
            get
            {
                string str = string.Empty;
                if (Read_Cache("upext") != null)
                    str = Read_Cache("upext").ToString();
                else
                {
                    str = KstCmsBase.Common.Fucs.GetConfigValue("upext");
                    Set_Cache("upext", str);
                }
                return str;
            }
        }
        #endregion

        #region Methods
        /// <summary>
        /// 面装载错误时发生
        /// </summary>
        /// <param name="e"></param>
        protected override void OnError(EventArgs e)
        {

            Exception objErr = Server.GetLastError().GetBaseException();
            StringBuilder ErrSB = new StringBuilder(objErr.Message);
            ErrSB.Replace("\"", "'");
            ErrSB.Replace("\r\n", "\\r\\n");
            if (!this.IsPostBack)
            {
                Server.ClearError();
                Response.Write("<script>alert(\"" + ErrSB.ToString() + "\");history.go(-1);</script>");
                Response.End();

            }
            else
            {
                base.OnError(e);
            }
        }

        /// <summary>
        /// 页面初始化
        /// </summary>
        /// <param name="e"></param>
        protected override void OnInit(EventArgs e)
        {
            //base.OnInit(e);
            System.Web.UI.WebControls.Literal litCopyRight;
            if (System.Web.HttpContext.Current.Cache.Get(User.Identity.Name + "_PageCopyright") != null)
                litCopyRight = (System.Web.UI.WebControls.Literal)System.Web.HttpContext.Current.Cache.Get(User.Identity.Name + "_PageCopyright");
            else
            {
                litCopyRight = new System.Web.UI.WebControls.Literal();
                litCopyRight.Text = CssAndCopyRight.InPageCopyRight + CssAndCopyRight.LinkCss;
                System.Web.HttpContext.Current.Cache.Add(User.Identity.Name + "_PageCopyright", litCopyRight, null, DateTime.Now.AddSeconds(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }

            Page.Header.Controls.Add(litCopyRight);
            //  Page.Title = WebTitle;
            if (!ClientScript.IsClientScriptIncludeRegistered(this.GetType(), "KOfficeJs"))
            {
                Page.ClientScript.RegisterClientScriptInclude("KOfficeJs", SysRootUrl + "/KstCMS_Manager/JavaScript/Koffice.js");
            }
        }

        /// <summary>
        /// 异步操作时人工提示成功信息
        /// </summary>
        /// <param name="Msg"></param>

        protected void ShowMsgModle(String Msg)
        {
            Msg = Msg.Replace("\"", "'");
            Msg = Msg.Replace("\r\n", "\\r\\n");
 
            System.Web.UI.ScriptManager.RegisterStartupScript((System.Web.UI.UpdatePanel)this.Page.FindControl("UpdatePanel1"), typeof(System.Web.UI.UpdatePanel), "SuccessMsg", "alert(\"" + Msg + "\");", true);
        }

        protected void ShowMsgModle(String Msg, String jsStr)
        {
            Msg = Msg.Replace("\"", "'");
            Msg = Msg.Replace("\r\n", "\\r\\n");
            System.Web.UI.ScriptManager.RegisterStartupScript((System.Web.UI.UpdatePanel)this.Page.FindControl("UpdatePanel1"), typeof(System.Web.UI.UpdatePanel), "SuccessMsg", "alert(\"" + Msg + "\");" + jsStr, true);
        }

        protected void ShowMsgModle(System.Web.UI.UpdatePanel UpdatePanel, String Msg)
        {
            Msg = Msg.Replace("\"", "'");
            Msg = Msg.Replace("\r\n", "\\r\\n");
            System.Web.UI.ScriptManager.RegisterStartupScript(UpdatePanel, typeof(System.Web.UI.UpdatePanel), "SuccessMsg", "alert(\"" + Msg + "\");", true);
        }
        protected void ShowMsgModle(System.Web.UI.UpdatePanel UpdatePanel, String Msg, String jsStr)
        {
            Msg = Msg.Replace("\"", "'");
            Msg = Msg.Replace("\r\n", "\\r\\n");
            System.Web.UI.ScriptManager.RegisterStartupScript(UpdatePanel, typeof(System.Web.UI.UpdatePanel), "SuccessMsg", "alert(\"" + Msg + "\");" + jsStr, true);
        }
        protected void Exejs(System.Web.UI.UpdatePanel UpdatePanel, String jsStr)
        {
            System.Web.UI.ScriptManager.RegisterStartupScript(UpdatePanel, typeof(System.Web.UI.UpdatePanel), "SuccessMsg", jsStr, true);
        }

        protected void Set_Cache(string Key, object Obj_value)
        {
            System.Web.HttpContext.Current.Cache.Add(Key, Obj_value, null, DateTime.Now.AddSeconds(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
        }

        protected object Read_Cache(string Key)
        {
            string ConfigPath = SysRootUrl + "/KstCMS.config";
            DateTime LastMod_dt = System.IO.File.GetLastWriteTime(Server.MapPath(ConfigPath));
            if (LastMod_dt != (DateTime)Application["KstcmsConfig"])
            {
                Clear_AllCache();
                Application["KstcmsConfig"] = LastMod_dt;
            }
            object MyObj = null;
            if (System.Web.HttpContext.Current.Cache.Get(Key) != null)
                MyObj = (object)System.Web.HttpContext.Current.Cache.Get(Key);
            return MyObj;
        }


        protected void Clear_Cache(string Key)
        {
            if (System.Web.HttpContext.Current.Cache.Get(Key) != null)
                System.Web.HttpContext.Current.Cache.Remove(Key);
        }

        protected void Clear_AllCache()
        {
            System.Collections.IDictionaryEnumerator ICache = System.Web.HttpContext.Current.Cache.GetEnumerator();
            while (ICache.MoveNext())
            {
                if (System.Web.HttpContext.Current.Cache.Get(ICache.Key.ToString()) != null)
                    System.Web.HttpContext.Current.Cache.Remove(ICache.Key.ToString());
            }
        }
/*
        protected void Clear_AllCache(string UserId)
        {
            System.Collections.IDictionaryEnumerator ICache = System.Web.HttpContext.Current.Cache.GetEnumerator();
            while (ICache.MoveNext())
            {
                if (ICache.Key.ToString().IndexOf(UserId) != -1)
                    if (System.Web.HttpContext.Current.Cache.Get(ICache.Key.ToString()) != null)
                        System.Web.HttpContext.Current.Cache.Remove(ICache.Key.ToString());
            }
        }
 */

        /// <summary>
        /// 设置临时链接地址
        /// </summary>
        /// <param name="Url"></param>
        protected void Save_TempUrl(string Url)
        {
            System.Web.HttpCookie cookie = new System.Web.HttpCookie("TempUrl");
            cookie.Value = Url;
            cookie.Path = "/";
            cookie.Expires = DateTime.Now.AddMinutes(CookieTime);
            Response.Cookies.Add(cookie);

        }

        /// <summary>
        /// 取临时链接地址
        /// </summary>
        /// <param name="toUrl"></param>
        /// <returns></returns>
        protected string Get_TempUrl(string toUrl)
        {
            System.Web.HttpCookie cookie = Request.Cookies["TempUrl"];
            string Url = SysRootUrl + "/KstCMS_Manager/" + toUrl;
            if (cookie != null)
                Url = cookie.Value;
            return Url;
        }

        /// <summary>
        /// 导航目录URL  路径后含"/"
        /// </summary>
        /// <param name="SiteId"></param>
        /// <param name="MenuId"></param>
        /// <returns></returns>
        protected  string GetSiteMenuUrl(int SiteId, int MenuId)
        {
            return SysRootUrl + "/" + KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId, "SiteVer").SiteVer + "/" + KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(MenuId, "MenuDiy").MenuDiy + "/";
        }



        public  int WebExeute
        {
            get
            {
                int Result = 0;
                if (System.Web.HttpContext.Current.Cache.Get("WebExecute") != null)
                    Result = Convert.ToInt32(System.Web.HttpContext.Current.Cache.Get("WebExecute").ToString());
                else
                {
                    Result = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("WebExecute"));
                    System.Web.HttpContext.Current.Cache.Add("WebExecute", Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                }
                return Result;
            }
        }

        protected  string HtmlExt
        {
            get
            {
                string Result = string.Empty;
                if (System.Web.HttpContext.Current.Cache.Get("htmlext") != null)
                    Result = System.Web.HttpContext.Current.Cache.Get("htmlext").ToString();
                else
                {
                    Result = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
                    System.Web.HttpContext.Current.Cache.Add("htmlext", Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                }
                return Result;
            }
        }



        #endregion
    }
}
