﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstWEB
{
    public class BaseWeb
    {
         protected static string SysRootUrl
         {
             get
             {
                 string RootUrl = string.Empty;
                 if (System.Web.HttpContext.Current.Cache.Get("RootUrl") != null)
                     RootUrl = System.Web.HttpContext.Current.Cache.Get("RootUrl").ToString();
                 else
                 {
                     RootUrl = KstCmsBase.Common.Fucs.GetRootURI();
                     System.Web.HttpContext.Current.Cache.Add("RootUrl", RootUrl, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                 }
                 return RootUrl;
             }
         }

         public static int WebExeute
         {
             get
             {
                 int Result = 0;
                 if (System.Web.HttpContext.Current.Cache.Get("WebExecute") != null)
                     Result = Convert.ToInt32(System.Web.HttpContext.Current.Cache.Get("WebExecute").ToString());
                 else
                 {
                     Result = Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("WebExecute"));
                     System.Web.HttpContext.Current.Cache.Add("WebExecute", Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                 }
                 return Result;
             }
         }

         protected static string HtmlExt
         {
             get
             {
                 string Result = string.Empty;
                 if (System.Web.HttpContext.Current.Cache.Get("htmlext") != null)
                     Result = System.Web.HttpContext.Current.Cache.Get("htmlext").ToString();
                 else
                 {
                     Result = KstCmsBase.Common.Fucs.GetConfigValue("htmlext");
                     System.Web.HttpContext.Current.Cache.Add("htmlext", Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                 }
                 return Result;
             }
         }

         protected static int ProPageSize
         {
             get
             {
                 string Result = string.Empty;
                 if (System.Web.HttpContext.Current.Cache.Get("product_pagesize") != null)
                     Result = System.Web.HttpContext.Current.Cache.Get("product_pagesize").ToString();
                 else
                 {
                     Result = KstCmsBase.Common.Fucs.GetConfigValue("product_pagesize");
                     System.Web.HttpContext.Current.Cache.Add("product_pagesize", Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
                 }
                 return Convert.ToInt32(Result);
             }
         }


         protected static int CacheTime
         {
             get
             {
                 return Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("cachetime"));
             }
         }

         protected static int CookieTime
         {

             get
             {
                 return Convert.ToInt32(KstCmsBase.Common.Fucs.GetConfigValue("cookietime"));
             }

         }
         #region ---------------------共公处理函数-------------------------
         protected static string GetSiteRoot(int SiteId)
         {
             return SysRootUrl + "/" + KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId, "SiteVer").SiteVer + "/";
         }

        /// <summary>
        /// 导航目录URL  路径后含"/"
        /// </summary>
        /// <param name="SiteId"></param>
        /// <param name="MenuId"></param>
        /// <returns></returns>
         protected static string GetSiteMenuUrl(int SiteId, int MenuId)
         {
             return SysRootUrl + "/" + KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId, "SiteVer").SiteVer + "/" + KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(MenuId, "MenuDiy").MenuDiy + "/";
         }

         protected static string GetLyFrm(int FrmId)
         {
             string Result = string.Empty;
             string CacheName = "frm" + FrmId.ToString();
             if (System.Web.HttpContext.Current.Cache.Get(CacheName) != null)
                 Result = System.Web.HttpContext.Current.Cache.Get(CacheName).ToString();
             else
             {
                 Result = KstCmsBase.DAL.Tag.TagTEMP.Get_TagDESC(FrmId).ContentTAG;
                 System.Web.HttpContext.Current.Cache.Add(CacheName, Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
             }             
             return Result;
         }


         #endregion


    }
}
