﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstWEB
{
    public class DynamicWeb:BaseWeb
    {
        public static void CreateIndexPage(int SiteId)
        {
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId);
            string TempHtml = GetTemplates(WebSite.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(WebSite.SiteID, 0, 0, string.Empty, 0, 0, 0);   ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            System.Web.HttpContext.Current.Response.Write(TempHtml);
        }

        public static void CreateMenuIndex(int SiteId, int MenuId)
        {
            //string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.WebMenu_ent WebMenu = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(MenuId, "GoUrl", "TempID");
            string TempHtml = GetTemplates(WebMenu.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, string.Empty, 0, 0, 0);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            System.Web.HttpContext.Current.Response.Write(TempHtml);
        }

        public static void CreateuPage(int SiteId, int MenuId, int LmId)
        {
            //string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.WebLm_ent lm = KstCmsBase.DAL.WebLM.Get_WebLMInfo(LmId, "uPageFile", "TempID");
            string TempHtml = GetTemplates(lm.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, LmId, string.Empty, 0, 0, 0);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            System.Web.HttpContext.Current.Response.Write(TempHtml);

        }
        public static void CreateProListOnPage(int SiteId, int MenuId, int lbid, string classid)
        {
            string Url = SysRootUrl + "/aspx/";  //导航Url
            string[] FileHtmls = null;  //用来暂返回的WEB页
            string ListTAG = string.Empty;
            KstCmsBase.Collection.Product.ProductCollection ProItems = null;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();

            KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(lbid, "TempID", "Alias");
            //string FilePath = Url + ProLB.Alias + "_";
            string FilePath = Url + "ShowList" + HtmlExt + "?SiteId=" + SiteId + "&MenuId=" + MenuId + "&ClassId=" + classid;
            string TempHtml = GetTemplates(ProLB.TempID.ToString());

            foreach (KstCmsBase.Entities.Tag.VarTAG_ent Tag in VarTAG_Items)
            {
                if (TempHtml.ToLower().IndexOf(Tag.VarTAG.ToLower()) != -1)
                {
                    KstWEB.TagAnaly.SysTAG SysTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, classid, 0, 0, 0);
                    // MyTAG.PageSize = ProPageSize;
                    string html = SysTAG.Handling_VarLable(Tag.TagContent);
                    string ListHtml = SysTAG.ListHtmlCode;
                    //解析签标内容后,返回HTML内容,如果VarTAG.TagContent中含有<!-kst:prolistonpage，处理后html会含有#page#,含有多个#page#列表就有多页
                    if (ListHtml.IndexOf("#page#") != -1)
                    {
                        ProItems = (KstCmsBase.Collection.Product.ProductCollection)SysTAG.DataCollection; //同步系统标签 处理产品分类列表标签时的产品数据集
                        ListTAG = Tag.VarTAG;
                        FileHtmls = ListHtml.Split(new string[] { "#page#" }, StringSplitOptions.RemoveEmptyEntries);
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                    }
                    else
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                }
            }
            if (ProItems != null)
                Handling_ShowPage(SiteId, FileHtmls, FilePath, TempHtml);
            else
            {
               // string FileUrl = System.Web.HttpContext.Current.Server.MapPath(FilePath + "0" + HtmlExt);
             //   KstCmsBase.Common.Fucs.DeleteFile(FileUrl);//删除旧文件
             //   System.IO.File.AppendAllText(FileUrl, TempHtml);
                System.Web.HttpContext.Current.Response.Write(TempHtml);
            }


        }

        public static void CreateWzListOnPage(int SiteId, int MenuId, int lbid)
        {
            string Url = SysRootUrl+"/aspx/";  //导航Url
            string[] ListPaent = null;  //用来暂存返回的列表内容
            string ListTAG = string.Empty;
            KstCmsBase.Collection.Wz.WzCollection WzItems = null;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            KstCmsBase.Entities.Wz.WzLB_Ent WzLB = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(lbid, "FileName", "TempID");
           // string FilePath = Url + WzLB.FileName + "_";
            string FilePath = Url + "WzList" + HtmlExt + "?SiteId=" + SiteId + "&MenuId=" + MenuId + "&Wzlbid=" + lbid.ToString();
            string TempHtml = GetTemplates(WzLB.TempID.ToString());

            foreach (KstCmsBase.Entities.Tag.VarTAG_ent Tag in VarTAG_Items)
            {
                if (TempHtml.ToLower().IndexOf(Tag.VarTAG.ToLower()) != -1)
                {
                    KstWEB.TagAnaly.SysTAG SysTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, string.Empty, 0, lbid, 0);
                    // MyTAG.PageSize = ProPageSize;
                    string html = SysTAG.Handling_VarLable(Tag.TagContent);
                    string ListHtml = SysTAG.ListHtmlCode;
                    //解析签标内容后,返回HTML内容,如果VarTAG.TagContent中含有<!-kst:prolistonpage，处理后html会含有#page#,含有多个#page#列表就有多页
                    if (ListHtml.IndexOf("#page#") != -1)
                    {
                        WzItems = (KstCmsBase.Collection.Wz.WzCollection)SysTAG.DataCollection; //同步系统标签 处理产品分类列表标签时的产品数据集
                        ListTAG = Tag.VarTAG;
                        ListPaent = ListHtml.Split(new string[] { "#page#" }, StringSplitOptions.RemoveEmptyEntries);
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                    }
                    else
                        TempHtml = TempHtml.Replace(Tag.VarTAG, html);
                }
            }
            if (WzItems != null)
                Handling_ShowPage(SiteId, ListPaent, FilePath, TempHtml);
            else
            {
             //   string FileUrl = System.Web.HttpContext.Current.Server.MapPath(FilePath + "0" + HtmlExt);
           //     KstCmsBase.Common.Fucs.DeleteFile(FileUrl);//删除旧文件
            //    System.IO.File.AppendAllText(FileUrl, TempHtml);
                System.Web.HttpContext.Current.Response.Write(TempHtml);
            }
        }

        private static void Handling_ShowPage(int SiteId, string[] FileHtmls, string FilePath, string TempHtml)
        {
            string First = "<img src=\"" + SysRootUrl + "/Styles/first.gif\" align=\"absmiddle\" border=\"0\" /> ";
            string First1 = "<img src=\"" + SysRootUrl + "/Styles/first1.gif\" align=\"absmiddle\" border=\"0\" /> ";
            string Prev = "<img src=\"" + SysRootUrl + "/Styles/prev.gif\" align=\"absmiddle\" border=\"0\" /> ";
            string Prev1 = "<img src=\"" + SysRootUrl + "/Styles/prev1.gif\" align=\"absmiddle\" border=\"0\" /> ";
            string Next = "<img src=\"" + SysRootUrl + "/Styles/next.gif\" align=\"absmiddle\" border=\"0\" /> ";
            string Next1 = "<img src=\"" + SysRootUrl + "/Styles/next1.gif\" align=\"absmiddle\" border=\"0\" /> ";
            string Last = "<img src=\"" + SysRootUrl + "/Styles/last.gif\" align=\"absmiddle\" border=\"0\" />";
            string Last1 = "<img src=\"" + SysRootUrl + "/Styles/last1.gif\" align=\"absmiddle\" border=\"0\" />";


            ///创建分页文件

                string ShowPageHtml = string.Empty;
                string ShowPageNo = string.Empty;
                string UrlFile = FilePath;
                string CurrentPage = System.Web.HttpContext.Current.Request.QueryString.Get("page");
                int PageNo = (!string.IsNullOrEmpty(CurrentPage) && CurrentPage != "") ? Convert.ToInt32(CurrentPage) : 1;
                string FileHtmlCode = TempHtml.Replace("#showlist#", FileHtmls[PageNo-1]);



                 string CurrentPageNo="[<span>" + PageNo + "</span>],";
                 for (int i = 1; i < PageNo; i++)
                 {
                     ShowPageNo += "<a href=\"" + FilePath + "&page=" + i + "\">" + i + "</a>,";
                 }
                 ShowPageNo += CurrentPageNo;
                 for (int i = PageNo+1; i <= FileHtmls.Length; i++)
                 {
                     ShowPageNo += "<a href=\"" + FilePath + "&page=" + i + "\">" + i + "</a>,";
                     if (i >= 10)
                         break;
                 }

                //到第一页
                if (PageNo != 0)
                    ShowPageHtml = "<a href=\"" + FilePath + "&page=1" + "\">" + First + "</a>";
                else
                    ShowPageHtml = First1;
                //到上一页
                if (PageNo > 0)
                    ShowPageHtml += "<a href=\"" + FilePath + "&page=" + 1 + "\">" + Prev + "</a>";
                else
                    ShowPageHtml += Prev1;

                ShowPageHtml += ShowPageNo;
                if (PageNo < (FileHtmls.Length))
                {
                    //到下一页
                    ShowPageHtml += "<a href=\"" + FilePath + "&page=" + (PageNo+1).ToString() + "\">" + Next + "</a>";
                    //到最后一页
                    ShowPageHtml += "<a href=\"" + FilePath + "&page=" + (FileHtmls.Length - 1).ToString() + "\">" + Last + "</a>";
                }
                else
                {
                    ShowPageHtml += Next1;
                    ShowPageHtml += Last1;
                }
                FileHtmlCode = FileHtmlCode.Replace("#showpage#", ShowPageHtml);
               // UrlFile = System.Web.HttpContext.Current.Server.MapPath(UrlFile);
              //  KstCmsBase.Common.Fucs.DeleteFile(UrlFile);//删除旧文件
              //  System.IO.File.AppendAllText(UrlFile, FileHtmlCode);
                System.Web.HttpContext.Current.Response.Write(FileHtmlCode);
                System.Web.HttpContext.Current.Response.End();
                
            
        }


        public static void CreateProduct(int SiteId, int MenuId, int lbid, string classid, int ProId)
        {
           // string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.Product.Product_Ent Pro = KstCmsBase.DAL.Product.Product.GetProductInfo(ProId, "FileName", "TempID");
            string TempHtml = GetTemplates(Pro.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, classid, ProId, 0, 0);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
         //   string File = FilePath + Pro.FileName + HtmlExt;
         //   File = System.Web.HttpContext.Current.Server.MapPath(File);
         //   KstCmsBase.Common.Fucs.DeleteFile(File);//删除旧文件
         //   System.IO.File.AppendAllText(File, TempHtml);
            System.Web.HttpContext.Current.Response.Write(TempHtml);
        }

        public static void CreateWz(int SiteId, int MenuId, int lbid, int Wzid)
        {
          //  string FilePath = GetSiteMenuUrl(SiteId, MenuId);
            KstCmsBase.Entities.Wz.Wz_Ent WZent = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Wzid, "FileName", "TempID");
            string TempHtml = GetTemplates(WZent.TempID.ToString());
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(SiteId, MenuId, 0, string.Empty, 0, lbid, Wzid);  ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
          //  string File = FilePath + WZent.FileName + HtmlExt;
          //  File = System.Web.HttpContext.Current.Server.MapPath(File);
          //  KstCmsBase.Common.Fucs.DeleteFile(File);//删除旧文件
          //  System.IO.File.AppendAllText(File, TempHtml);
            System.Web.HttpContext.Current.Response.Write(TempHtml);
        }

        public static void CreateSiteMap(int SiteId)
        {
            string TempHtml = KstCmsBase.DAL.Templates.GetDefaultTemplate(KstCmsBase.DAL.Templates.TempType.SiteMap, SiteId).TempContent;
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId);
            string FilePath = SysRootUrl + "/" + WebSite.SiteVer + "/SiteMap" + HtmlExt;
            if (WebSite.DefaultSite == 1)
                FilePath = SysRootUrl + "/SiteMap" + HtmlExt;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(WebSite.SiteID, 0, 0, string.Empty, 0, 0, 0);   ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            FilePath = System.Web.HttpContext.Current.Server.MapPath(FilePath);
            KstCmsBase.Common.Fucs.DeleteFile(FilePath);//删除旧文件
           System.IO.File.AppendAllText(FilePath, TempHtml);
            
        }

        public static void CreateLinkPage(int SiteId)
        {
            string TempHtml = KstCmsBase.DAL.Templates.GetDefaultTemplate(KstCmsBase.DAL.Templates.TempType.Link, SiteId).TempContent;
            KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(SiteId);
            string FilePath = SysRootUrl + "/" + WebSite.SiteVer + "/Link" + HtmlExt;
            if (WebSite.DefaultSite == 1)
                FilePath = SysRootUrl + "/Link" + HtmlExt;
            KstCmsBase.Collection.Tag.VarTAGCollection VarTAG_Items = KstCmsBase.DAL.Tag.TagTEMP.GetVarTAGCollection();
            foreach (KstCmsBase.Entities.Tag.VarTAG_ent VarTAG in VarTAG_Items)  ///历遍自定议标签
            {
                if (TempHtml.ToLower().IndexOf(VarTAG.VarTAG.ToLower()) != -1)  ///模板中含有自定义标签
                {
                    KstWEB.TagAnaly.SysTAG MyTAG = new TagAnaly.SysTAG(WebSite.SiteID, 0, 0, string.Empty, 0, 0, 0);   ///创建系统标签实例
                    string html = MyTAG.Handling_VarLable(VarTAG.TagContent); //解析自定义签标内容，之后,返回HTML内容.
                    TempHtml = TempHtml.Replace(VarTAG.VarTAG, html);
                }
            }
            FilePath = System.Web.HttpContext.Current.Server.MapPath(FilePath);
            KstCmsBase.Common.Fucs.DeleteFile(FilePath);//删除旧文件
            System.IO.File.AppendAllText(FilePath, TempHtml);
        }



        private static string GetTemplates(string TempId)
        {

            string Result = string.Empty;
            if (System.Web.HttpContext.Current.Cache.Get("TempId" + TempId) != null)
                Result = System.Web.HttpContext.Current.Cache.Get("TempId" + TempId).ToString();
            else
            {
                Result = KstCmsBase.DAL.Templates.GetTemplate(TempId).TempContent;
                if (!string.IsNullOrEmpty(Result))
                    System.Web.HttpContext.Current.Cache.Add("TempId" + TempId, Result, null, DateTime.Now.AddMinutes(CacheTime), TimeSpan.Zero, System.Web.Caching.CacheItemPriority.Normal, null);
            }
            return Result;
        }


    }
}
