﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstWEB.TagAnaly
{
    public class SysTAG:BaseWeb
    {
        #region-------实例化转入参数及属性-------------
        private int _SiteId;
       private int _MenuId;
       private int _LmId;
       private string _ProClassId = string.Empty;
       private int _ProId;
       private int _Wzlbid;
       private int _WzId;
       private string _HtmlCode = string.Empty;
       
       public string ListHtmlCode
       {
           get { return _HtmlCode; }
       }
       private KstCmsBase.Collection.BaseCollection _Collection;
       public KstCmsBase.Collection.BaseCollection DataCollection
       {
           get { return _Collection; }
       }
       private int _CurrentPage = 1;
       private int _PageSize = 0;
       public int CurrentPage
       {
           set { _CurrentPage = value; }
           get { return _CurrentPage; }
       }
       public int PageSize
       {
           get { return _PageSize; }
       }
        #endregion
       public SysTAG(int SiteId,int MenuId,int LmId,string ProClassId,int ProId,int Wzlbid,int WzId)
       {
           _SiteId = SiteId; _MenuId = MenuId; _LmId = LmId;
           _ProClassId = ProClassId; _ProId = ProId;
           _Wzlbid = Wzlbid; _WzId = WzId;
           _CurrentPage = 1;

       }
/// <summary>
/// 标签处理    函数标签格式：<!-kst:函数名[参数列1,参数列2,...]-!> 非函数标签格式：<!-kst:函数名-!>
/// </summary>
/// <param name="VarHtmlCode">包函标签的自定义HTML代码</param>
/// <returns></returns>
       public string Handling_VarLable(string VarHtmlCode)
       {
           
           string ResultHtml = VarHtmlCode;
          
           KstCmsBase.Collection.Tag.SysTAGCollection SysTAG_Items = KstCmsBase.DAL.Tag.SysTAG.GetSysTagItems();
           foreach (KstCmsBase.Entities.Tag.SysTAG_ent SysTAG in SysTAG_Items) ///历遍系统标签数据表
           {
               string lb=SysTAG.SysTAG.ToLower();
               if (lb.IndexOf("[") != -1 && lb.IndexOf("]")!=-1)
               {
                   ///取函数签标头如<!-kst:upage[
                   lb = lb.Substring(0, lb.IndexOf("[") + 1);   
                   Handling_FunLabel(lb, ref ResultHtml);  ///处理函数标签
               }
               else
               {
                   if (ResultHtml.IndexOf("<!-kst:webtitle-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_WebTitle());
                   if (ResultHtml.IndexOf("<!-kst:metakey-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_Metakey());
                   if (ResultHtml.IndexOf("<!-kst:metadescription-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_Metadescription());
                   if (ResultHtml.IndexOf("<!-kst:footer-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_FooterPage());
                   if (ResultHtml.IndexOf("<!-kst:location-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_location());
                   if (ResultHtml.IndexOf("<!-kst:prevandnext-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_PrevAndNext());
                   if (ResultHtml.IndexOf("<!-kst:homeurl-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_HomeUrl());
                   if (ResultHtml.IndexOf("<!-kst:sitemap-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, Get_HomeSiteMap());
                   if (ResultHtml.IndexOf("<!-kst:linkpage-!>")!=-1)
                       ResultHtml = ResultHtml.Replace(lb, Get_Link());
                   if (ResultHtml.IndexOf("<!-kst:showpage-!>") != -1)
                       ResultHtml = ResultHtml.Replace(lb, "#showpage#");

               }
           }
           return ResultHtml;

       }
        /// <summary>
        /// 处理函数标签
        /// </summary>
        /// <param name="FunTabel">函数标签头</param>
        /// <param name="HtmlCode">包含标签的HTML代码</param>
       private void Handling_FunLabel(string FunTabel,ref string HtmlCode)
       {
           int Stag=0, Etag=0;
           string ParmList = string.Empty;
          
           while (HtmlCode.IndexOf(FunTabel) != -1)
           {
               Stag = HtmlCode.IndexOf(FunTabel) + FunTabel.Length;
               Etag = HtmlCode.IndexOf("]-!>", Stag);
               ParmList = HtmlCode.Substring(Stag, Etag - Stag);///取函数参数列表如格式 0,1,2,3
               string[] Para = ParmList.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
               switch (FunTabel)
               {
                   case "<!-kst:sitemenu[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_SiteMenu(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1])));
                       break;
                   case "<!-kst:upage[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_uPage(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1])));
                       break;
                   case "<!-kst:menutitle[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_MenuTitle(Convert.ToInt32(Para[0])));
                       break;
                   case "<!-kst:lmtitle[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_LmTitle(Convert.ToInt32(Para[0])));
                       break;
                   case "<!-kst:proclassnav[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_ProClassNav(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1]), Convert.ToInt32(Para[2])));
                       break;
                   case "<!-kst:wzclassnav[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_WzClassNav(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1])));
                       break;
                  //标签模板相关
                   case "<!-kst:lmnavigation[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_LmNavigation(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1])));
                       break;
                 //产品列表相关
                   case "<!-kst:prolist[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_Prolist(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1]), Para[2], Convert.ToInt32(Para[3]), Convert.ToInt32(Para[4]), Convert.ToInt32(Para[5])));
                       break;
                   case "<!-kst:prolistonpage[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_ProlistOnPage(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1]), Para[2], Convert.ToInt32(Para[3]), Convert.ToInt32(Para[4]), Convert.ToInt32(Para[5]), ref _CurrentPage));
                       break;
                //文章列表相关
                   case "<!-kst:wzlist[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_WzList(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1]), Convert.ToInt32(Para[2]), Convert.ToInt32(Para[3]), Convert.ToInt32(Para[4]), Convert.ToInt32(Para[5]), Convert.ToInt32(Para[6])));
                       break;
                   case "<!-kst:wzlistonpage[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_WzListOnPage(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1]), Convert.ToInt32(Para[2]), Convert.ToInt32(Para[3]), Convert.ToInt32(Para[4]), Convert.ToInt32(Para[5]), Convert.ToInt32(Para[6]), ref _CurrentPage));
                       break;
                //内容相关
                   case "<!-kst:procontent[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_ProContent(Convert.ToInt32(Para[0]), Para[1], Convert.ToInt32(Para[2])));
                       break;
                   case "<!-kst:wzcontent[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_WzContent(Convert.ToInt32(Para[0])));
                       break;
                   case "<!-kst:link[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_Link(Convert.ToInt32(Para[0]), Convert.ToInt32(Para[1]), Convert.ToInt32(Para[2]), Convert.ToInt32(Para[3]), Convert.ToInt32(Para[4]), Convert.ToInt32(Para[5])));
                       break;
                   case "<!-kst:lyfrm[":
                       HtmlCode = HtmlCode.Replace(FunTabel + ParmList + "]-!>", Get_LyFrm(Convert.ToInt32(Para[0]),Convert.ToInt32(Para[1]),Convert.ToInt32(Para[2])));
                       break;

               }
           }
       }


       #region-----------------非函数标签解析--------------------------------------->
       /// <summary>
/// 解析网页标题标签
/// </summary>
/// <returns></returns>
       private string Get_WebTitle()
       {
           string Result = string.Empty;
           KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(_SiteId, "SiteTitle");
           Result = WebSite.SiteTitle;  ///网页首页标题
           if (!string.IsNullOrEmpty(_ProClassId) || _ProId!=0)  ///产品页的网站标题
           {
               string ProLB_title = string.Empty;
               if (!string.IsNullOrEmpty(_ProClassId))   ///产品分类列表页的网页标题
               {
                   string lbid = string.Empty;
                   if (_ProClassId.IndexOf(",") != -1)
                       lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);
                   else
                       lbid = _ProClassId;
                   KstCmsBase.DAL.Product.ProLB.Get_LBPATH(lbid, ref ProLB_title);

               }

               if (_ProId!=0)        ///产品内容页的网页标题
               {
                   KstCmsBase.Entities.Product.Product_Ent ProEnt = KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(_ProId), "LbID", "ProName");
                   _ProClassId = ProEnt.LbID.Substring(0, ProEnt.LbID.LastIndexOf(","));
                   string lbid = string.Empty;
                   if (_ProClassId.IndexOf(",") != -1)
                       lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);
                   else
                       lbid = _ProClassId;
                   KstCmsBase.DAL.Product.ProLB.Get_LBPATH(lbid, ref ProLB_title);
                   ProLB_title = ProEnt.ProName + "/" + ProLB_title;
               }
               Result = ProLB_title + "--" + Result;
           }
           else    
           {
               string TitleStr = string.Empty;
               if (_MenuId != 0)
                   TitleStr = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "MenuName").MenuName; ///累加导航首页标题
               if (_LmId != 0)
                   TitleStr += "/" + KstCmsBase.DAL.WebLM.Get_WebLMInfo(_LmId, "LmName").LmName;       ///累加栏目单页标题
               //以处理下文章，图片，下载这些内容标题路径
               if (_Wzlbid != 0)
                   TitleStr += "/" + KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(_Wzlbid, "LbName").LbName;
               if (_WzId != 0)
                   TitleStr += "/" + KstCmsBase.DAL.Wz.Wz.Get_WzInfo(_WzId, "WzTitle").WzTitle;
               Result = TitleStr + "--" + Result;
           }
           return Result;
       }
/// <summary>
/// 解析网页META关建字标签
/// </summary>
/// <returns></returns>
       private string Get_Metakey()
       {
           string Result = string.Empty;
           if (!string.IsNullOrEmpty(_ProClassId) || _ProId != 0)   ///产品页的META
           {
               if (!string.IsNullOrEmpty(_ProClassId))
               {
                   string lbid = string.Empty;
                   if (_ProClassId.IndexOf(",") != -1)
                       lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);
                   else
                       lbid = _ProClassId;
                   Result = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(lbid), "MataKey").MateKey;
               }
               if (_ProId != 0)
                   Result = KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(_ProId), "MateKey").MateKey;
           }
           else
           {
               KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(_SiteId, "MateKey");
               Result = WebSite.MateKey;
               if (_MenuId != 0)
                   Result = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "MateKey").MateKey;
               if (_LmId != 0)
                   Result = KstCmsBase.DAL.WebLM.Get_WebLMInfo(_LmId, "MateKey").MateKey;
               //以处理下文章
               if (_Wzlbid != 0)
                   Result = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(_Wzlbid, "MateKey").MateKey;
               if (_WzId != 0)
                   Result = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(_WzId, "MateKey").MateKey;
               //图片，下载这些网页的Mate
           }
           return Result;
       }
/// <summary>
/// 解析网页META注解标签
/// </summary>
/// <returns></returns>
       private string Get_Metadescription()
       {
           string Result = string.Empty;
           if (!string.IsNullOrEmpty(_ProClassId) || _ProId != 0)  //产品页META
           {
               if (!string.IsNullOrEmpty(_ProClassId))
               {
                   string lbid = string.Empty;
                   if (_ProClassId.IndexOf(",") != -1)
                       lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);
                   else
                       lbid = _ProClassId;
                   Result = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(lbid), "MateDesc").MateDesc;
               }
               if (_ProId != 0)
                   Result = KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(_ProId), "MateDesc").MateDesc;
           }
           else
           {
               KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(_SiteId, "MateDesc");
               Result = WebSite.MateDesc;
               if (_MenuId != 0)
                   Result = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "MateDesc").MateDesc;
               if (_LmId != 0)
                   Result = KstCmsBase.DAL.WebLM.Get_WebLMInfo(_LmId, "MateDesc").MateDesc;
               //以处理下文章，图片，下载这些网页的Mate
               if (_Wzlbid != 0)
                   Result = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(_Wzlbid, "MateDesc").MateDesc;
               if (_WzId != 0)
                   Result = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(_WzId, "MateDesc").MateDesc;
               //图片，下载这些网页的Mate
           }
           return Result;
       }
/// <summary>
/// 网站页脚Copyright
/// </summary>
/// <returns></returns>
       private string Get_FooterPage()
       {
           string Result = KstCmsBase.DAL.WebSite.Get_WebSite_Info(_SiteId, "CopyRight").CopyRight;
           return Result;
       }
/// <summary>
/// 解析您的位置标签 注意如果为动态网页 导航首页为index,单页为:uPage,产品列表为ShowList,产品内容为ShowPro,文章列表WzList,文章内容ShowAct
/// </summary>
/// <returns></returns>
       private string Get_location()
       {
           string Result = string.Empty;
           //KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(_SiteId, "SiteVer", "DefaultSite");
           string UrlPath = GetSiteMenuUrl(_SiteId, _MenuId);
           if (WebExeute != 1) UrlPath = SysRootUrl + "/aspx/";
           if (_MenuId != 0)   //导航首页
           {
               KstCmsBase.Entities.WebMenu_ent WebMenu = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "MenuName", "MenuDiy", "GoUrl", "IsOutUrl", "GoLmID", "AttRib");
               if (WebMenu.IsOutUrl != 1)  //非外部链接
               {
                   if (WebMenu.GoLmID != 0)  //邦定了子栏目
                   {
                       switch (WebMenu.AttRib)
                       {
                           case 0:
                               KstCmsBase.Entities.WebLm_ent WebLM = KstCmsBase.DAL.WebLM.Get_WebLMInfo(WebMenu.GoLmID, "LmName", "uPageFile");
                               if (WebExeute == 1)
                                  Result = "<a href=\"" + UrlPath  + WebLM.uPageFile + HtmlExt + "\">" + WebMenu.MenuName + "</a>";
                               else
                                  Result = "<a href=\"" + UrlPath + "uPage" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&LmId=" + WebMenu.GoLmID + "\">" + WebMenu.MenuName + "</a>";
                               break;
                           case 1:
                               KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(WebMenu.GoLmID, "Alias");
                               if (WebExeute == 1)
                                   Result += "<a href=\"" + UrlPath + ProLB.Alias + "_0" + HtmlExt + "\">" + WebMenu.MenuName + "</a>";
                               else
                               {
                                   string ids = string.Empty;
                                   KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(WebMenu.GoLmID.ToString(), ref ids);
                                   Result += "<a href=\"" + UrlPath + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + ids + "\">" + WebMenu.MenuName + "</a>";
                               }
                               break;
                           case 2:
                               KstCmsBase.Entities.Wz.WzLB_Ent Wzlb = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(WebMenu.GoLmID, "FileName");
                               if (WebExeute == 1)
                                   Result += "<a href=\"" + UrlPath + Wzlb.FileName + "_0" + HtmlExt + "\">" + WebMenu.MenuName + "</a>";
                               else
                               {
                                   Result += "<a href=\"" + UrlPath + "WzList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&Wzlbid=" + WebMenu.GoLmID + "\">" + WebMenu.MenuName + "</a>";
                               }
                               break;
                           case 3:
                               break;
                           case 4:
                               break;


                       }
                   }
                   else
                   {
                       if (WebExeute == 1)
                           Result = "<a href=\"" + UrlPath  + WebMenu.GoUrl + HtmlExt + "\">" + WebMenu.MenuName + "</a>";
                       else
                           Result = "<a href=\"" + UrlPath + "index" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "\">" + WebMenu.MenuName + "</a>";
                   }
               }
             
           }
           if (_LmId != 0)  //栏目单页
           {
               KstCmsBase.Entities.WebLm_ent WebLM = KstCmsBase.DAL.WebLM.Get_WebLMInfo(_LmId, "LmName", "uPageFile");
               if (WebExeute == 1)
                   Result += " / <a href=\"" + UrlPath + WebLM.uPageFile + HtmlExt + "\">" + WebLM.LmName + "</a>";
               else
                   Result += " / <a href=\"" + UrlPath + "uPage" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&LmId=" + _LmId + "\">" + WebLM.LmName + "</a>";
           }

           if (!string.IsNullOrEmpty(_ProClassId))
           {
               string lburl=string.Empty;
               string lbid = string.Empty;
               if (_ProClassId.IndexOf(",") != -1)
                   lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);
               else
                   lbid = _ProClassId;
               KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(lbid), "Alias");
               if (WebExeute == 1)
                   KstCmsBase.DAL.Product.ProLB.Get_LBUrlPATH(lbid, UrlPath + ProLB.Alias + "_0" + HtmlExt, WebExeute, ref lburl);
               else
                   KstCmsBase.DAL.Product.ProLB.Get_LBUrlPATH(lbid, UrlPath + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId, WebExeute, ref lburl);
               Result += " / " + lburl;
           }
      //     if (_ProId != 0)
      //         Result += "/" + KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(_ProId), "ProName").ProName;

           ///以下处理文章、图片、下载相关
           if (_Wzlbid != 0)
           {
               KstCmsBase.Entities.Wz.WzLB_Ent Wzlb = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(_Wzlbid, "LbName", "FileName");
               if (WebExeute == 1)
                   Result += " / <a href=\"" + UrlPath + Wzlb.FileName + "_0" + HtmlExt + "\">" + Wzlb.LbName + "</a>";
               else
                   Result += " / <a href=\"" + UrlPath + "WzList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&Wzlbid=" + _Wzlbid + "\">" + Wzlb.LbName + "</a>";
           }
           return Result;
       }
        /// <summary>
        /// 产品、文章、下载、图片等内容页的上下记录链接信息
        /// </summary>
        /// <returns></returns>
       private string Get_PrevAndNext()
       {
           string Result = string.Empty;

           string UrlPath = GetSiteMenuUrl(_SiteId, _MenuId);
           if (WebExeute != 1) UrlPath = SysRootUrl + "/aspx/";
           if (_ProId != 0)
               Result = ProPrevAndNext(Result, UrlPath);///处理产品内容上下产品信息链接
           if (_WzId != 0)
               Result = WzPrevAndNext(Result, UrlPath);
           return Result;
       }

       private string WzPrevAndNext(string Result, string UrlPath)
       {
           KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
           string PrevId = db.getFieldValue(string.Format("select top 1 WzID from WzList where WzID<{0} order by WzID asc", _WzId.ToString()));
           string NextId = db.getFieldValue(string.Format("select top 1 WzID from WzList where WzID>{0} order by WzID asc", _WzId.ToString()));
           if (!string.IsNullOrEmpty(PrevId))
           {
               KstCmsBase.Entities.Wz.Wz_Ent WZ = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Convert.ToInt32(PrevId), "LbID", "WzTitle", "FileName");
               if (WebExeute == 1)
               {
                   if (!string.IsNullOrEmpty(WZ.FileName) && WZ.FileName != "")
                       Result = "PREV:<a href=\"" + UrlPath + WZ.FileName + HtmlExt + "\">" + WZ.WzTitle + "</a>";
               }
               else
               {
                   Result = "PREV:<a href=\"" + UrlPath + "ShowAct" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&Wzlbid=" + WZ.LbID + "&WzId=" + PrevId + "\">" + WZ.WzTitle + "</a>";
               }
           }
           else
           {
               Result = "PREV: No Item";
           }
           if (!string.IsNullOrEmpty(NextId))
           {
               KstCmsBase.Entities.Wz.Wz_Ent WZ = KstCmsBase.DAL.Wz.Wz.Get_WzInfo(Convert.ToInt32(NextId), "LbID", "WzTitle", "FileName");
               if (WebExeute == 1)
               {
                   if (!string.IsNullOrEmpty(WZ.FileName) && WZ.FileName != "")
                       Result += "<br />NEXT:<a href=\"" + UrlPath + WZ.FileName + HtmlExt + "\">" + WZ.WzTitle + "</a>";
               }
               else
               {
                   Result += "<br />NEXT:<a href=\"" + UrlPath + "ShowAct" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&Wzlbid=" + WZ.LbID + "&WzId=" + NextId + "\">" + WZ.WzTitle + "</a>";
               }
           }
           else
           {
               Result += "<br />NEXT:No Item";
           }
           return Result;
       }
       private string ProPrevAndNext(string Result, string UrlPath)
       {
           KstCmsBase.DAL.Access db = new KstCmsBase.DAL.Access();
           string PrevId = db.getFieldValue(string.Format("select top 1 ProID from Products where ProID<{0} order by ProID asc", _ProId.ToString()));
           string NextId = db.getFieldValue(string.Format("select top 1 ProID from Products where ProID>{0} order by ProID asc", _ProId.ToString()));
           if (!string.IsNullOrEmpty(PrevId))
           {
               KstCmsBase.Entities.Product.Product_Ent ProEnt = KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(PrevId), "ProID", "LbID", "ProName", "FileName");
               if (WebExeute == 1)
               {
                   if (!string.IsNullOrEmpty(ProEnt.FileName) && ProEnt.FileName != "")
                       Result = "PREV:<a href=\"" + UrlPath + ProEnt.FileName + HtmlExt + "\">" + ProEnt.ProName + "</a>";
               }
               else
               {
                   string classid = ProEnt.LbID.Substring(0, ProEnt.LbID.LastIndexOf(","));
                   Result = "PREV:<a href=\"" + UrlPath + "ShowPro" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + classid + "&ProId=" + PrevId + "\">" + ProEnt.ProName + "</a>";
               }
           }
           else
           {
               Result = "PREV: No Item";
           }
           if (!string.IsNullOrEmpty(NextId))
           {
               KstCmsBase.Entities.Product.Product_Ent ProEnt = KstCmsBase.DAL.Product.Product.GetProductInfo(Convert.ToInt32(NextId), "ProID", "LbID", "ProName", "FileName");
               if (WebExeute == 1)
               {
                   if (!string.IsNullOrEmpty(ProEnt.FileName) && ProEnt.FileName != "")
                       Result += "<br />NEXT:<a href=\"" + UrlPath + ProEnt.FileName + HtmlExt + "\">" + ProEnt.ProName + "</a>";
               }
               else
               {
                   string classid = ProEnt.LbID.Substring(0, ProEnt.LbID.LastIndexOf(","));
                   Result += "<br />NEXT:<a href=\"" + UrlPath + "ShowPro" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + classid + "&ProId=" + NextId + "\">" + ProEnt.ProName + "</a>";
               }
           }
           else
           {
               Result += "<br />NEXT:No Item";
           }
           db.Dispose();
           return Result;
       }

        /// <summary>
        /// 取网站根目录
        /// </summary>
        /// <returns></returns>
       private string Get_HomeUrl()
       {
           string Result = string.Empty;
           KstCmsBase.Entities.WebSite_ent WebSite = KstCmsBase.DAL.WebSite.Get_WebSite_Info(_SiteId, "SiteVer", "DefaultSite");
           if (WebSite.DefaultSite == 1)
               Result = SysRootUrl + "/";
           else
               Result = SysRootUrl + "/" + WebSite.SiteVer + "/";
           return Result;
       }

       private string Get_HomeSiteMap()
       {
           string Result = string.Empty;
           string PathUrl = GetSiteRoot(_SiteId);
           KstCmsBase.Collection.WebMenuCollection MenuItems = KstCmsBase.DAL.WebMenu.Get_MenuList(_SiteId);
           StringBuilder htmlsb = new StringBuilder();
           foreach (KstCmsBase.Entities.WebMenu_ent Menu in MenuItems)
           {
               #region -----------导航类型---------------
               if (Menu.IsOutUrl != 1)
               {
                   if (Menu.GoLmID != 0)
                   {
                       switch (Menu.AttRib)
                       {
                           case 0:
                               KstCmsBase.Entities.WebLm_ent WebLM = KstCmsBase.DAL.WebLM.Get_WebLMInfo(Menu.GoLmID, "LmName", "uPageFile");
                               if (WebExeute == 1)
                                   htmlsb.Append("<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + WebLM.uPageFile + HtmlExt + "\">" + Menu.MenuName + "</a></li>");
                               else
                                   htmlsb.Append("<li><a href=\"" + SysRootUrl + "/aspx/uPage" + HtmlExt + "?SiteId=" + Menu.SiteID + "&MenuId=" + Menu.MenuID + "&LmId=" + Menu.GoLmID + "\">" + Menu.MenuName + "</a></li>");
                               break;
                           case 1:
                               KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Menu.GoLmID, "Alias");
                               if (WebExeute == 1)
                                   htmlsb.Append("<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + ProLB.Alias + "_0" + HtmlExt + "\">" + Menu.MenuName + "</a></li>");
                               else
                               {
                                   string ClassId = string.Empty;
                                   KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(Menu.GoLmID.ToString(), ref ClassId);
                                   htmlsb.Append("<li><a href=\"" + SysRootUrl + "/aspx/ShowList" + HtmlExt + "?SiteId=" + Menu.SiteID + "&MenuId=" + Menu.MenuID + "&ClassId=" + ClassId + "\">" + Menu.MenuName + "</a></li>");
                               }
                               break;
                           case 2:
                               KstCmsBase.Entities.Wz.WzLB_Ent WzLB = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(Menu.GoLmID, "FileName");
                               if(WebExeute==1)
                                   htmlsb.Append("<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + WzLB.FileName + "_0" + HtmlExt + "\">" + Menu.MenuName + "</a></li>");
                               else
                                   htmlsb.Append("<li><a href=\"" + SysRootUrl + "/aspx/WzList" + HtmlExt + "?SiteId=" + Menu.SiteID + "&MenuId=" + Menu.MenuID + "&Wzlbid=" + Menu.GoLmID + "\">" + Menu.MenuName + "</a></li>");
                               break;
                           case 3:
                               break;
                           case 4:
                               break;
                           case 5:
                               break;
                       }
                   }
                   else
                   {
                       if (WebExeute == 1)
                           htmlsb.Append("<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + Menu.GoUrl + HtmlExt + "\">" + Menu.MenuName + "</a></li>");
                       else
                           htmlsb.Append("<li><a href=\"" + PathUrl + Menu.MenuDiy + "/index" + HtmlExt + "?SiteId=" + _SiteId.ToString() + "&MenuId=" + Menu.MenuID.ToString() + "\">" + Menu.MenuName + "</a></li>");
                   }
               }
               #endregion

               #region----下级栏目------
               string subhtml = string.Empty;
               switch (Menu.AttRib)
               {
                   case 0:
                       subhtml = "";
                       KstCmsBase.Collection.WebLmCollection WebLmItems = KstCmsBase.DAL.WebLM.Get_LMList(Menu.MenuID, "LmID", "LmName", "uPageFile");
                       foreach (KstCmsBase.Entities.WebLm_ent WebLM in WebLmItems)
                       {
                           if (WebExeute == 1)
                               subhtml += "<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + WebLM.uPageFile + HtmlExt + "\">" + Menu.MenuName + "</a></li>";
                           else
                               subhtml += "<li><a href=\"" + SysRootUrl + "/aspx/uPage" + HtmlExt + "?SiteId=" + Menu.SiteID + "&MenuId=" + Menu.MenuID + "&LmId=" + Menu.GoLmID + "\">" + Menu.MenuName + "</a></li>";
                           break;
                       }
                       subhtml = "<ul>" + subhtml + "</ul>";
                       break;
                   case 1:
                       subhtml = "";
                       KstCmsBase.Collection.Product.ProLBCollection ProLBITEMS = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(Menu.SiteID, Menu.MenuID, 0, "LbID", "LbName", "Alias");
                       foreach (KstCmsBase.Entities.Product.ProLB_Ent ProLB in ProLBITEMS)
                       {
                           if (WebExeute == 1)
                               subhtml += "<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + ProLB.Alias + "_0" + HtmlExt + "\">" + ProLB.LbName + "</a></li>";
                           else
                           {
                               subhtml += "<li><a href=\"" + SysRootUrl + "/aspx/ShowList" + HtmlExt + "?SiteId=" + Menu.SiteID + "&MenuId=" + Menu.MenuID + "&ClassId=" + ProLB.LbID + "\">" + ProLB.LbName + "</a></li>";
                           }
                       }
                       subhtml = "<ul>" + subhtml + "</ul>";
                       break;
                   case 2:
                       subhtml = "";
                       KstCmsBase.Collection.Wz.WzLBCollection Wzlbitems = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(Menu.SiteID, Menu.MenuID, "LbID", "LbName", "FileName");
                       foreach (KstCmsBase.Entities.Wz.WzLB_Ent Wzlb in Wzlbitems)
                       {
                           if(WebExeute==1)
                               subhtml += "<li><a href=\"" + PathUrl + Menu.MenuDiy + "/" + Wzlb.FileName + "_0" + HtmlExt + "\">" + Wzlb.LbName + "</a></li>";
                           else
                               subhtml += "<li><a href=\"" + SysRootUrl + "/aspx/WzList" + HtmlExt + "?SiteId=" + Menu.SiteID + "&MenuId=" + Menu.MenuID + "&Wzlbid=" + Wzlb.LbID + "\">" + Wzlb.LbName + "</a></li>";

                       }
                       subhtml = "<ul>" + subhtml + "</ul>";
                       break;
                   case 3:
                       break;
                   case 4:
                       break;
                   case 5:
                       break;
               }

               #endregion

               htmlsb.Append(subhtml);
           }
           Result = htmlsb.ToString();
           return Result;
       }

       private string Get_Link()
       {
           string Result = string.Empty;
           KstCmsBase.Collection.Link.LinkLBCollection LinklbItems = KstCmsBase.DAL.Link.FLink.Get_LinkLB_Items();
           StringBuilder htmlsb = new StringBuilder();
           foreach (KstCmsBase.Entities.Link.LinkLB LinkLB in LinklbItems)
           {
               htmlsb.Append("<li>" + LinkLB.LbName + "</li>");
               KstCmsBase.Collection.Link.LinkCollection LinkITEMS = KstCmsBase.DAL.Link.FLink.Get_Link_Items(_SiteId, 0, KstCmsBase.DAL.Link.FLink.LinkType.allLink);
               string logohtml = string.Empty;
               string wzhtml=string.Empty;
               foreach (KstCmsBase.Entities.Link.LinkEnt link in LinkITEMS)
               {
                   if (link.LogoUrl != "" && !string.IsNullOrEmpty(link.LogoUrl))
                       logohtml += "<dt><a href=\"" + link.LinkUrl + "\"><img src=\"" + link.LogoUrl + "\" alt=\"" + link.SiteName + "\" border=\"0\" /></a></dt>";
                   else
                       wzhtml += "<a href=\"" + link.LinkUrl + "\" title=\"" + link.SiteName + "\">" + link.LinkName + "</a>&nbsp;&nbsp;";
               }
               if (!string.IsNullOrEmpty(logohtml))
                   logohtml = "<dl>" + logohtml + "</dl>";
               if (!string.IsNullOrEmpty(wzhtml))
                   wzhtml = "<ul>" + wzhtml + "</ul>";
               htmlsb.Append(logohtml + wzhtml);
           }
           Result = htmlsb.ToString();
           return Result;
       }


 #endregion

       #region-----------------函数标签解析------------------------------///
        /// <summary>
        /// 获取网站导航条
        /// </summary>
        /// <param name="SiteId">网站ID[0：表示当前站点]</param>
        /// <param name="ShowPopMenu">是否显示下拉菜单</param>
        /// <returns></returns>
       private string Get_SiteMenu(int SiteId, int ShowPopMenu)
       {
           if (SiteId != 0)
               _SiteId = SiteId;
           string SiteRootUrl=GetSiteRoot(_SiteId);
           string Result = string.Empty;
           string ieif="\r\n<!--[if IE 7]><!--></a><!--<![endif]-->\r\n<!--[if lte IE 6]><table><tr><td><![endif]-->\r\n";
           KstCmsBase.Collection.WebMenuCollection WebMenu = KstCmsBase.DAL.WebMenu.Get_MenuList(_SiteId, true, "MenuID", "MenuName", "MenuDiy", "GoUrl", "IsOutUrl", "GoLmID", "AttRib");
           foreach (KstCmsBase.Entities.WebMenu_ent Menu in WebMenu)
           {
               if (Menu.IsOutUrl == 1)  //外部链接
                   Result += "<li><a href=\"" + Menu.GoUrl + "\" target=\"_blank\">" + Menu.MenuName;
               else
               {
                   if (Menu.GoLmID == 0)  //内部链接 未邦定子栏目
                   {
                       if (WebExeute == 1)
                           Result += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + Menu.GoUrl + HtmlExt + "\">" + Menu.MenuName;
                       else
                           Result += "<li><a href=\"" + SysRootUrl + "/aspx/index" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "\">" + Menu.MenuName;
                   }
                   else   //内部链接 邦定子栏目
                   {
                       switch (Menu.AttRib)
                       {
                           case 0:
                               KstCmsBase.Entities.WebLm_ent WebLM = KstCmsBase.DAL.WebLM.Get_WebLMInfo(Menu.GoLmID, "uPageFile");
                               if (WebExeute == 1)
                                   Result += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + WebLM.uPageFile + HtmlExt + "\">" + Menu.MenuName;
                               else
                                   Result += "<li><a href=\"" + SysRootUrl + "/aspx/uPage" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&LmId=" + Menu.GoLmID + "\">" + Menu.MenuName;
                               break;
                           case 1:
                               KstCmsBase.Entities.Product.ProLB_Ent ProLB = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Menu.GoLmID, "Alias");
                               if (WebExeute == 1)
                                   Result += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + ProLB.Alias + "_0" + HtmlExt + "\">" + Menu.MenuName;
                               else
                               {
                                   string ids=string.Empty;
                                   KstCmsBase.DAL.Product.ProLB.GetAny_ParentLBID(Menu.GoLmID.ToString(), ref ids);
                                   Result += "<li><a href=\"" + SysRootUrl + "/aspx/ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&ClassId=" + ids + "\">" + Menu.MenuName;
                               }
                               break;
                           case 2:
                               KstCmsBase.Entities.Wz.WzLB_Ent Wzlb = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(Menu.GoLmID, "FileName");
                               if (WebExeute == 1)
                                   Result += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + Wzlb.FileName + "_0" + HtmlExt + "\">" + Menu.MenuName;
                               else
                               {
                                   Result += "<li><a href=\"" + SysRootUrl + "/aspx/WzList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&Wzlbid=" + Menu.GoLmID + "\">" + Menu.MenuName;
                               }
                               break;
                           case 3: //图片
                               break;
                           case 4:
                               //下载
                               break;
                       }
                   }
               }
               ///显示子栏目

               if (ShowPopMenu == 1)
               {
                   Result += ieif;
                   Result = ShowSubMenu(SiteRootUrl, Result, Menu);
               }
               else
               {
                   
                   Result += "</a></li>\r\n";
               }
              
           }
           return Result;
       }

        /// <summary>
        /// 子菜单
        /// </summary>
        /// <param name="SiteRootUrl"></param>
        /// <param name="Result"></param>
        /// <param name="Menu"></param>
        /// <returns></returns>
       private string ShowSubMenu(string SiteRootUrl, string Result, KstCmsBase.Entities.WebMenu_ent Menu)
       {
           string SubMenu = string.Empty;
           string ieendul = "\r\n<!--[if lte IE 6]></td></tr></table></a><![endif]-->\r\n";
           string ieif = "\r\n<!--[if IE 7]><!--></a><!--<![endif]-->\r\n<!--[if lte IE 6]><table><tr><td><![endif]-->\r\n";
           switch (Menu.AttRib)
           {
               case 0:
                   SubMenu = string.Empty;
                   KstCmsBase.Collection.WebLmCollection LmItems = KstCmsBase.DAL.WebLM.Get_LMList(_SiteId, Menu.MenuID, 1, "LmID", "LmName", "uPageFile");
                   foreach (KstCmsBase.Entities.WebLm_ent Lm in LmItems)
                   {
                       if (WebExeute == 1)
                           SubMenu += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + Lm.uPageFile + HtmlExt + "\">" + Lm.LmName + "</a></li>\r\n";
                       else
                           SubMenu += "<li><a href=\"" + SysRootUrl + "/aspx/uPage" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&LmId=" + Lm.LmID + "\">" + Lm.LmName + "</a></li>\r\n";
                   }
                   if (!string.IsNullOrEmpty(SubMenu))
                       Result += "<ul>" + SubMenu + "</ul>" + ieendul + "</li>\r\n";
                   else
                       Result += "</li>";
                   break;
               case 1:
                   SubMenu = string.Empty;
                   KstCmsBase.Collection.Product.ProLBCollection ProLB_items = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(_SiteId, Menu.MenuID, 0, "LbID", "LbName", "Alias");
                   foreach (KstCmsBase.Entities.Product.ProLB_Ent ProLB in ProLB_items)
                   {
                       KstCmsBase.Collection.Product.ProLBCollection SubProLB_Items = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(ProLB.LbID, "LbID", "LbName", "Alias");
                       if (SubProLB_Items.Count == 0)
                       {
                           if (WebExeute == 1)
                               SubMenu += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + ProLB.Alias + "_0" + HtmlExt + "\">" + ProLB.LbName + "</a>\r\n";
                           else
                               SubMenu += "<li><a href=\"" + SysRootUrl + "/aspx/ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&ClassId=" + ProLB.LbID + "\">" + ProLB.LbName + ieif;
                       }
                       else
                       {
                           if (WebExeute == 1)
                               SubMenu += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + ProLB.Alias + "_0" + HtmlExt + "\">" + ProLB.LbName + "</a>\r\n";
                           else
                               SubMenu += "<li><a href=\"" + SysRootUrl + "/aspx/ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&ClassId=" + ProLB.LbID + "\">" + ProLB.LbName + ieif;
                       }
                       string SubProLB = string.Empty;
                       
                       foreach (KstCmsBase.Entities.Product.ProLB_Ent SubPro in SubProLB_Items)  ///二及产品类别
                       {
                           if (WebExeute == 1)
                               SubProLB += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + SubPro.Alias + "_0" + HtmlExt + "\">" + SubPro.LbName + "</a></li>\r\n";
                           else
                               SubProLB += "<li><a href=\"" + SysRootUrl + "/aspx/ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&ClassId=" + ProLB.LbID + "," + SubPro.LbID + "\">" + SubPro.LbName + "</a></li>\r\n";
                       }
                       if (!string.IsNullOrEmpty(SubProLB))
                           SubMenu += "<ul>" + SubProLB + "</ul>" + ieendul + "</li>\r\n";
                       else
                           SubMenu += "</li>\r\n";
                   }
                   if (!string.IsNullOrEmpty(SubMenu))
                       Result += "<ul>" + SubMenu + "</ul>" + ieendul + "</li>\r\n";
                   else
                       Result += "</li>\r\n";
                   break;
               case 2:
                   SubMenu = string.Empty;
                   KstCmsBase.Collection.Wz.WzLBCollection WzLB_items = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(_SiteId, Menu.MenuID, "LbID", "LbName", "FileName");
                   foreach (KstCmsBase.Entities.Wz.WzLB_Ent lb in WzLB_items)
                   {
                       if (WebExeute == 1)
                           SubMenu += "<li><a href=\"" + SiteRootUrl + Menu.MenuDiy + "/" + lb.FileName + "_0" + HtmlExt + "\">" + lb.LbName + "</a></li>\r\n";
                       else
                           SubMenu += "<li><a href=\"" + SysRootUrl + "/aspx/WzList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + Menu.MenuID + "&Wzlbid=" + lb.LbID + "\">" + lb.LbName + "</a></li>\r\n";
                   }
                   if (!string.IsNullOrEmpty(SubMenu))
                       Result += "<ul>" + SubMenu + "</ul>" + ieendul + "</li>\r\n";
                   else
                       Result += "</li>\r\n";
                   break;
           }
           return Result;
       }
        /// <summary>
        /// 取单页内容
        /// </summary>
        /// <param name="LmId">单页栏目ID</param>
        /// <param name="Lenght">过滤HTML后，载取内容长度</param>
        /// <returns></returns>
       private string Get_uPage(int LmId, int Lenght)
       {
           if (LmId != 0)
               _LmId = LmId;
           string Result = string.Empty;
           KstCmsBase.Entities.WebLm_ent uPage = KstCmsBase.DAL.WebLM.Get_WebLMInfo(_LmId, "Content");
           Result = uPage.Content;
           if (Lenght != 0)
           {
               Result = KstCmsBase.Common.Fucs.NoHTML(Result);
               if (Result.Length > Lenght)
                   Result = Result.Substring(0, Lenght) + "...";
           }
           return Result;
       }
        /// <summary>
        /// 取导航标题
        /// </summary>
        /// <param name="MenuId">导航ID</param>
        /// <returns></returns>
       private string Get_MenuTitle(int MenuId)
       {
           if(MenuId!=0)
               _MenuId=MenuId;
           string Result = string.Empty;
           Result = KstCmsBase.DAL.WebMenu.Get_WebMenuInfo(_MenuId, "MenuName").MenuName;
           return Result;
       }
       /// <summary>
       /// 取单页栏目标题
       /// </summary>
       /// <param name="LmId"></param>
       /// <returns></returns>
       private string Get_LmTitle(int LmId)
       {
           string Result = string.Empty;
           if (LmId != 0)_LmId = LmId;

               
               Result = KstCmsBase.DAL.WebLM.Get_WebLMInfo(_LmId, "LmName").LmName;
               if (string.IsNullOrEmpty(Result) || Result == "")
               {
                   if (!string.IsNullOrEmpty(_ProClassId))
                   {
                       string lbid = string.Empty;
                       if (_ProClassId.IndexOf(",") != -1)
                       {
                           lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);

                       }
                       else
                       {
                           lbid = _ProClassId;
                       }
                       KstCmsBase.DAL.Product.ProLB.Get_LBPATH(lbid.ToString(), ref Result);
                       // Result = KstCmsBase.DAL.Product.ProLB.Get_ProLbInfo(Convert.ToInt32(lbid), "LbName").LbName;
                       //  return Result;
                   }

                   if (_Wzlbid != 0)
                       Result = KstCmsBase.DAL.Wz.WzLB.Get_WzlbInfo(Convert.ToInt32(_Wzlbid), "LbName").LbName;

               }
           
           return Result;
       }
/// <summary>
/// 产品分类左则导航..多最显示二级分类
/// </summary>
/// <param name="SiteId"></param>
/// <param name="MenuId"></param>
/// <param name="IsExt"></param>
/// <returns></returns>
       private string Get_ProClassNav(int SiteId, int MenuId, int IsExt)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           string Url = GetSiteMenuUrl(_SiteId,_MenuId);
           if (WebExeute != 1) Url = SysRootUrl + "/aspx/";
           string lbid = string.Empty;
           if (!string.IsNullOrEmpty(_ProClassId))
           {
               if (_ProClassId.IndexOf(",") != -1)
                   lbid = _ProClassId.Substring(_ProClassId.LastIndexOf(",") + 1);
               else
                   lbid = _ProClassId;
           }
           KstCmsBase.Collection.Product.ProLBCollection ProLBItems = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(_SiteId, _MenuId, 0, "LbID", "LbName", "Alias");
           bool IsCurrert = false;
           foreach (KstCmsBase.Entities.Product.ProLB_Ent ProLB in ProLBItems)
           {

               if (WebExeute == 1)
               {
                   if (lbid == ProLB.LbID.ToString())
                   {
                       IsCurrert = true;
                       Result += "<li class=\"lbselected\" onclick=\"OpenSublb('sublb" + ProLB.LbID.ToString() + "');\"><a href=\"" + Url + ProLB.Alias + "_0" + HtmlExt + "\">" + ProLB.LbName + "</a></li>";
                   }
                   else
                   {
                       IsCurrert = false;
                       Result += "<li onclick=\"OpenSublb('sublb" + ProLB.LbID.ToString() + "');\"><a href=\"" + Url + ProLB.Alias + "_0" + HtmlExt + "\">" + ProLB.LbName + "</a></li>";
                   }
               }
               else
               {
                   if (lbid == ProLB.LbID.ToString())
                   {
                       IsCurrert = true;
                       Result += "<li class=\"lbselected\" onclick=\"OpenSublb('sublb" + ProLB.LbID.ToString() + "');\"><a href=\"" + Url + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + ProLB.LbID + "\">" + ProLB.LbName + "</a></li>";
                   }
                   else
                   {
                       IsCurrert = false;
                       Result += "<li onclick=\"OpenSublb('sublb" + ProLB.LbID.ToString() + "');\"><a href=\"" + Url + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + ProLB.LbID + "\">" + ProLB.LbName + "</a></li>";
                   }
               }
               KstCmsBase.Collection.Product.ProLBCollection SubLBItems = KstCmsBase.DAL.Product.ProLB.Get_ProLBList(ProLB.LbID, "LbID", "ParentID", "LbName", "Alias");
               string SubHtml = string.Empty;
               foreach (KstCmsBase.Entities.Product.ProLB_Ent Sublb in SubLBItems)
               {
                   if (WebExeute == 1)
                   {
                       if (Sublb.LbID.ToString() == lbid)
                       {
                           IsCurrert = true;
                           SubHtml += "<li class=\"lbselected\"><a href=\"" + Url + Sublb.Alias + "_0" + HtmlExt + "\">" + Sublb.LbName + "</a></li>";
                       }
                       else
                       {
                          // IsCurrert = false;
                           SubHtml += "<li><a href=\"" + Url + Sublb.Alias + "_0" + HtmlExt + "\">" + Sublb.LbName + "</a></li>";
                       }
                   }
                   else
                   {
                       if (Sublb.LbID.ToString() == lbid)
                       {
                           IsCurrert = true;
                           SubHtml += "<li class=\"lbselected\"><a href=\"" + Url + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + ProLB.LbID + "," + Sublb.LbID + "\">" + Sublb.LbName + "</a></li>";
                       }
                       else
                       {
                          // IsCurrert = false;
                           SubHtml += "<li><a href=\"" + Url + "ShowList" + HtmlExt + "?SiteId=" + _SiteId + "&MenuId=" + _MenuId + "&ClassId=" + ProLB.LbID + "," + Sublb.LbID + "\">" + Sublb.LbName + "</a></li>";
                       }
                   }
               }
               if (IsExt == 1)
                   SubHtml = "<ul id=\"sublb" + ProLB.LbID + "\">" + SubHtml + "</ul>";
               else
               {
                   if(IsCurrert)
                       SubHtml = "<ul id=\"sublb" + ProLB.LbID + "\">" + SubHtml + "</ul>";
                   else
                       SubHtml = "<ul id=\"sublb" + ProLB.LbID + "\" style=\"display:none\">" + SubHtml + "</ul>";
               }
               Result += SubHtml;
           }
           return Result;
       }
/// <summary>
/// 文章分类导航
/// </summary>
/// <param name="SiteId"></param>
/// <param name="MenuId"></param>
/// <returns></returns>
       private string Get_WzClassNav(int SiteId, int MenuId)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           string Url = GetSiteMenuUrl(_SiteId, _MenuId);
           if (WebExeute != 1) Url = SysRootUrl + "/aspx/";
           KstCmsBase.Collection.Wz.WzLBCollection WzLBITEMS = KstCmsBase.DAL.Wz.WzLB.Get_WzLbCollection(_SiteId, _MenuId, "LbID", "LbName", "FileName");
           foreach (KstCmsBase.Entities.Wz.WzLB_Ent lbitem in WzLBITEMS)
           {
               if (WebExeute == 1)
                   Result += "<li><a href=\"" + Url + lbitem.FileName + "_0" + HtmlExt + "\">" + lbitem.LbName + "</a></li>";
               else
                   Result += "<li><a href=\"" + Url + "WzList" + HtmlExt + "?SiteId=" + _SiteId.ToString() + "&MenuId=" + _MenuId + "&Wzlbid=" + lbitem.LbID.ToString() + "\">" + lbitem.LbName + "</a></li>";
           }
           return Result;
       }

/// <summary>
/// 处理栏目导航
/// </summary>
/// <param name="MenuId"></param>
/// <param name="TagId"></param>
/// <returns></returns>
       private string Get_LmNavigation(int MenuId, int TagId)
       {
           string Result = string.Empty;
           if (MenuId != 0)
               _MenuId = MenuId;
           KstCmsBase.Collection.WebLmCollection LmItems = KstCmsBase.DAL.WebLM.Get_LMList(_SiteId, _MenuId, 1, "LmID", "SiteID", "MenuID", "LmName", "uPageFile");
           ListTAG TmpTAG = new ListTAG(TagId, _SiteId, _MenuId);
           int Count = 1;
           TmpTAG.Handling_TagTemp(LmItems,ref Count);
           Result = TmpTAG.HtmlCode;
           return Result;
       }
/// <summary>
/// 产品列表
/// </summary>
/// <param name="SiteId">站点ID</param>
/// <param name="MenuId">导航ID</param>
/// <param name="ProNum">产品数量</param>
/// <param name="Attrib">属性</param>
/// <param name="TagId">列表模板ID</param>
/// <returns></returns>
       private string Get_Prolist(int SiteId, int MenuId, string ClassIds, int ProNum, int Attrib, int TagId)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           KstCmsBase.Collection.Product.ProductCollection ProItems=null;
           if (ClassIds.ToLower() != "0")
               _ProClassId = ClassIds.Replace("|", ",");
           if (!string.IsNullOrEmpty(_ProClassId))
               ProItems = KstCmsBase.DAL.Product.Product.GetProductList(_ProClassId,_SiteId, _MenuId, ProNum, Attrib, "ProID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "ProDoc", "uTime", "FileName");
           else
               ProItems = KstCmsBase.DAL.Product.Product.GetProductList(_SiteId, _MenuId, ProNum, Attrib, "ProID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "ProDoc", "uTime", "FileName");
           ListTAG TmpTAG = new ListTAG(TagId, _SiteId, _MenuId);
           int Count = 1;
           TmpTAG.Handling_TagTemp(ProItems, ref Count);
           Result = TmpTAG.HtmlCode;
           return Result;
       }
/// <summary>
/// 文章列表
/// </summary>
/// <param name="SiteId">站点ID</param>
/// <param name="MenuId">导航ID</param>
/// <param name="WzNum">列表数（文章数）</param>
/// <param name="Attrib">属性</param>
/// <param name="HasPic">有图的或不限</param>
/// <param name="TagId">列表模板ID</param>
/// <returns></returns>
       private string Get_WzList(int SiteId, int MenuId,int LbID, int WzNum, int Attrib, int HasPic, int TagId)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           bool t = HasPic == 1 ? true : false;

           KstCmsBase.Collection.Wz.WzCollection WzItems = null;
           if (LbID != 0)
               WzItems = KstCmsBase.DAL.Wz.Wz.Get_WzList(LbID, Attrib, t, WzNum, "WzID", "LbID", "WzTitle", "WzPic", "WzPic1", "WzDoc", "uTime", "FileName");
           else
               WzItems = KstCmsBase.DAL.Wz.Wz.Get_WzList(_SiteId, _MenuId, Attrib, t, WzNum, "WzID", "LbID", "WzTitle", "WzPic", "WzPic1", "WzDoc", "uTime", "FileName");
           ListTAG TmpTAG = new ListTAG(TagId, _SiteId, _MenuId);
           int Count = 1;
           TmpTAG.Handling_TagTemp(WzItems, ref Count);
           Result = TmpTAG.HtmlCode;
           return Result;
       }

       private string Get_Link(int SiteId, int MenuId, int LinkType, int LinkCount, int isHome, int TagId)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           KstCmsBase.Collection.Link.LinkCollection LinkItems = null;
           if (LinkType != 0)
               LinkItems = KstCmsBase.DAL.Link.FLink.Get_Link_Items(_SiteId, _MenuId, KstCmsBase.DAL.Link.FLink.Ltype.logoLink, LinkCount);
           else
               LinkItems = KstCmsBase.DAL.Link.FLink.Get_Link_Items(_SiteId, _MenuId, KstCmsBase.DAL.Link.FLink.Ltype.wzLink, LinkCount);
           ListTAG TmpTAG = new ListTAG(TagId, _SiteId, _MenuId);
           int Count = 1;
           TmpTAG.Handling_TagTemp(LinkItems, ref Count);
           Result = TmpTAG.HtmlCode;
           return Result;
       }

       private string Get_LyFrm(int SiteId, int Lylb, int TagId)
       {
           if (SiteId != 0) _SiteId = SiteId;
           string Result = GetLyFrm(TagId);
           Result = Result.Replace("#lylbid#", Lylb.ToString());
           return Result;
       }



/// <summary>
/// 处理产品分页标签
/// </summary>
/// <param name="SiteId">站点ID</param>
/// <param name="MenuId">导航ID</param>
/// <param name="classid">产品分类</param>
/// <param name="PageSize">显示每页产品数量</param>
/// <param name="Attrib">显示属性</param>
/// <param name="TagId">列表模板ID</param>
/// <param name="_CurrentPage">当前页码，根据不同的页码过滤产品集</param>
/// <returns>返回以“#page#”隔开的产品分页列表,供建立分页文件使用</returns>
       private string Get_ProlistOnPage(int SiteId, int MenuId, string classid,int PageSize, int Attrib, int TagId, ref int _CurrentPage)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           _PageSize = PageSize;
            KstCmsBase.Collection.Product.ProductCollection ProItems = null;
            if (classid.Trim().ToLower() != "0") _ProClassId = classid.Replace("|", ",");
            if (!string.IsNullOrEmpty(_ProClassId))
                ProItems = KstCmsBase.DAL.Product.Product.GetProductList(_ProClassId, _SiteId, _MenuId, Attrib, "ProID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "ProDoc", "uTime", "FileName");
            else
                ProItems = KstCmsBase.DAL.Product.Product.GetProductList(null, _SiteId, _MenuId, Attrib, "ProID", "LbID", "ProNo", "ProName", "Pic1", "Pic2", "Pic3", "ProDoc", "uTime", "FileName");
            string TypeName = ProItems.GetType().Name;
           
           System.Collections.ArrayList items = null;
         //  if (ProItems.Count == 0)
         //      _CurrentPage = 0;
           if (_CurrentPage * _PageSize < ProItems.Count)
               items = ProItems.GetRange(_PageSize * (_CurrentPage - 1), _PageSize);
           else
           {
               int EndCount = ProItems.Count - ((_CurrentPage - 1) * _PageSize);
               items = ProItems.GetRange(_PageSize * (_CurrentPage - 1), EndCount);
           }
           ListTAG TmpTAG = new ListTAG(TagId, _SiteId, _MenuId);
           int RowCount = 1;
           TmpTAG.Handling_TagTemp(items, ref RowCount,TypeName);
           _HtmlCode += TmpTAG.HtmlCode + "#page#";
           Result = "#showlist#";
           if (_CurrentPage * _PageSize < ProItems.Count)
           {
               _CurrentPage++;
               Get_ProlistOnPage(_SiteId, _MenuId, _ProClassId, _PageSize, Attrib, TagId, ref _CurrentPage);
           }
           else
           {
               _Collection = ProItems;
               
           }
           return Result;
       }

       private string Get_WzListOnPage(int SiteId, int MenuId, int Wzlbid, int PageSize, int Attrib, int HasPic, int TagId, ref int _CurrentPage)
       {
           string Result = string.Empty;
           if (SiteId != 0) _SiteId = SiteId;
           if (MenuId != 0) _MenuId = MenuId;
           if (Wzlbid != 0) _Wzlbid = Wzlbid;
           _PageSize = PageSize;
           bool t = HasPic == 1 ? true : false;
           KstCmsBase.Collection.Wz.WzCollection WzItems = KstCmsBase.DAL.Wz.Wz.Get_WzList(_SiteId, _MenuId, _Wzlbid, Attrib, t, "WzID", "LbID", "WzTitle", "WzPic", "WzPic1", "WzDoc", "uTime", "FileName");
           string TypeName = WzItems.GetType().Name;
           System.Collections.ArrayList items = null;
          // if (WzItems.Count == 0)
          //     _CurrentPage = 0;
           if (_CurrentPage * _PageSize < WzItems.Count)
               items = WzItems.GetRange(_PageSize * (_CurrentPage - 1), _PageSize);
           else
           {
               int EndCount = WzItems.Count - ((_CurrentPage - 1) * _PageSize);
               items = WzItems.GetRange(_PageSize * (_CurrentPage - 1), EndCount);
           }

           ListTAG TmpTAG = new ListTAG(TagId, _SiteId, _MenuId);
           int RowCount = 1;
           TmpTAG.Handling_TagTemp(items, ref RowCount, TypeName);
           _HtmlCode += TmpTAG.HtmlCode + "#page#";
           Result = "#showlist#";
           if (_CurrentPage * _PageSize < WzItems.Count)
           {
               _CurrentPage++;
               Get_WzListOnPage(_SiteId, _MenuId, Wzlbid, _PageSize, Attrib, HasPic, TagId, ref _CurrentPage);
           }
           else
           {
               _Collection = WzItems;
              
           }
           return Result;
       }

/// <summary>
       /// 解析产品内容标签
/// </summary>
/// <param name="TagId">内容模板ID</param>
/// <param name="lytitle">显示咨询标题</param>
/// <returns></returns>
       private string Get_ProContent(int TagId,string lytitle,int FrmId)
       {
           string Result = string.Empty;
           KstWEB.TagAnaly.ContentTAG tag = new ContentTAG(_SiteId, _MenuId, TagId);
           tag.Handling_ProContent(_ProId,lytitle,FrmId);
           Result = tag.HtmlCode;
           return Result;
       }

       private string Get_WzContent(int TagId)
       {
           string Result = string.Empty;
           KstWEB.TagAnaly.ContentTAG tag = new ContentTAG(_SiteId, _MenuId, TagId);
           tag.Handling_WzContent(_WzId);
           Result = tag.HtmlCode;
           return Result;
       }

       #endregion





    }
}
