﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MVCBlogo.NET.BO;
using MVCBlogo.NET.DAL;
namespace BusinessLogic
{
    public class AuthorManage
    {
        /// <summary>
        /// 获取的是Author表的数据总数
        /// </summary>
        /// <param name="StartRow"></param>
        /// <param name="PageSize"></param>
        /// <returns></returns>
        public static int Count(int StartRow, int PageSize)
        {
           return AuthorDB.Count(StartRow, PageSize);
        }

        /// <summary>
        /// 对于Author表的数据删除
        /// </summary>
        /// <param name="myAuthor"></param>
        /// <returns></returns>
        public static bool Delete(Author myAuthor)
        {
            if (myAuthor != null)
                return AuthorDB.Delete(myAuthor.id);
            else
                return false;
        }

        /// <summary>
        /// 通过id号来获取Author业务实体对象
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static Author GetItem(int id)
        {
            return AuthorDB.GetItem(id);
        }

        /// <summary>
        /// 通过用户名来获取Author业务实体对象
        /// </summary>
        /// <param name="username"></param>
        /// <returns></returns>
        public static Author GetItem(string username)
        {
            return AuthorDB.GetItem(username);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <returns></returns>
        public static List<Author> GetList()
        {
            return AuthorDB.GetList();
        }

        /// <summary>
        /// 通过传入分页的起始行号和分页的大小来获取列表
        /// </summary>
        /// <param name="StartRow"></param>
        /// <param name="PageSize"></param>
        /// <returns></returns>
        public static List<Author> GetList(int StartRow, int PageSize)
        {
            return AuthorDB.GetList(StartRow, PageSize);
        }

        /// <summary>
        /// 保存数据的方法
        /// </summary>
        /// <param name="myAuthor"></param>
        /// <returns></returns>
        public static int Save(Author myAuthor)
        {
            return AuthorDB.Save(myAuthor);
        }
    }
}
