﻿using System.Linq;
using System.Data.Linq;
using System.Collections.Generic;
using DataAccess.Mapping;
using MVCBlogo.NET.BO;
using System.Web.Configuration;
using System.Web.Security;
using Utils;

namespace MVCBlogo.NET.DAL
{
    public static class AuthorDB
    {
        private static BlogMapDataContext db = new BlogMapDataContext();

        /// <summary>
        /// 返回的就是数据的总数
        /// </summary>
        /// <returns></returns>
        public static int Count(int StartRow, int PageSize)
        {
            return db.authors.Count();
        }

       
        public static Author GetItem(int id)
        {
            authors t = (from author in db.authors where author.id == id select author).FirstOrDefault();
            return FillRecord(t);
        }

        public static Author GetItem(string username)
        {
            authors t = (from author in db.authors where author.username == username select author).FirstOrDefault();
            return FillRecord(t);
        }

        public static List<Author> GetList()
        {
            var query = from author in db.authors orderby author.username ascending select author;
            List<Author> result = new List<Author>();
            foreach (var t in query)
                result.Add(FillRecord(t));

        
            return  result ;
        }

        public static List<Author> GetList(int StartRow, int PageSize)
        {
            var query = (from author in db.authors orderby author.username ascending select author).Skip(StartRow).Take(PageSize);
            List<Author> result = new List<Author>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        /// <summary>
        /// 修改authors表的数据，修改包括添加数据或者更新数据
        /// </summary>
        /// <param name="myAuthor"></param>
        /// <returns></returns>
        public static int Save(Author myAuthor)
        {
            authors t;
            bool found = false;
            
            if (myAuthor.id == -1) //表明myAuthor里没有数据，向表里新增一条新的数据
            {
               
                var dupe = (from author in db.authors where author.username == myAuthor.username select author).FirstOrDefault();
                if (dupe != null)
                {
                    //用户名已经存在的时候
                    found = false;
                    t = null;
                }
                else {
                t = new authors();
                t.salt = Hash.GenerateSalt(32);
                t.password = Hash.HashPassword(t.password, t.salt);
                db.authors.InsertOnSubmit(t);
                found = true;
                }
            }
            else
            {
                // 查询的记录存在的情况下
                t = (from author in db.authors where author.id == myAuthor.id select author).FirstOrDefault();
                if (t != null)
                {
                    found = true;
                    t.id = myAuthor.id;
                }
            }

            if (found)
            {

                t.username = myAuthor.username;
                t.salt = Hash.GenerateSalt(32);
                t.password = Hash.HashPassword(t.password, t.salt);

                try
                {
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
                return t.id;
            }
            else
                return -1;
          
        }

        /// <summary>
        /// 根据id号进行的删除操作
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static bool Delete(int id)
        {
            authors t = (from author in db.authors where author.id == id select author).FirstOrDefault();
            if (t != null)
            {
                try
                {
                    db.authors.DeleteOnSubmit(t);
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
            }
            return (t!=null);
        }

        /// <summary>
        /// 传入一个authors的对象进去，返回的是一个Author的业务实体对象
        /// </summary>
        /// <param name="i"></param>
        /// <returns></returns>
        private static Author FillRecord(authors i)
        {
            Author result = null;
            if (i != null)
            {
                result = new Author();
                result.id = i.id;
                result.username = i.username;
                result.password = i.password;
                result.salt = i.salt;
            }
            return result;
        }
    }
}
