﻿using System.Linq;
using System.Data.Linq;
using System.Collections.Generic;
using System;
using DataAccess.Mapping;
using MVCBlogo.NET.BO;

namespace MVCBlogo.NET.DAL
{
    public static class CommentDB
    {
        private static BlogMapDataContext db = new BlogMapDataContext();
        
        public static int Count(int StartRow, int PageSize)
        {
            return db.comments.Count();
        }

        public static Comment GetItem(int id)
        {
            comments t = (from comment in db.comments where comment.id == id select comment).FirstOrDefault();
            return FillRecord(t);
        }

        public static List<Comment> GetList()
        {
            var query = from comment in db.comments orderby comment.datecreated descending select comment;
            List<Comment> result = new List<Comment>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }


        public static List<Comment> GetList(int StartRow, int PageSize)
        {
            var query = (from comment in db.comments orderby comment.datecreated descending select comment).Skip(StartRow).Take(PageSize);
            List<Comment> result = new List<Comment>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }


        public static List<Comment> GetList(long parent_id)
        {
            var query = from comment in db.comments where comment.blog_id == parent_id orderby comment.datecreated ascending select comment;
            List<Comment> result = new List<Comment>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        public static long Save(Comment myComment)
        {
            comments t;
            bool found = false;

            if (myComment.id == -1)
            {
                // new record
                t = new comments();
                db.comments.InsertOnSubmit(t);
                found = true;
            }
            else
            {
                // existing record
                t = (from comment in db.comments where comment.id == myComment.id select comment).FirstOrDefault();
                if (t != null)
                {
                    found = true;
                    t.id = myComment.id;
                }
            }

            if (found)
            {

                t.author = myComment.author;
                t.blog_id = myComment.blog_id;
                t.ip = myComment.IP;
                t.datecreated = myComment.datecreated;
                t.datepulished= myComment.datecreated ;
                t.body = myComment.body;

                try
                {
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
                return t.id;
            }
            else
                return -1;
          
        }

        public static bool Delete(long id)
        {
            comments t = (from comment in db.comments where comment.id == id select comment).FirstOrDefault();
            if (t != null)
            {
                try
                {
                    db.comments.DeleteOnSubmit(t);
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
            }
            return (t!=null);
        }

        private static Comment FillRecord(comments i)
        {
            Comment result = null;
            if (i != null)
            {
                result = new Comment();
                result.id = i.id;
                result.author = i.author;
                result.blog_id = Convert.ToInt32(i.blog_id);
                result.IP = i.ip;
                result.datecreated = Convert.ToDateTime(i.datecreated);
                result.datemodified =Convert.ToDateTime(i.datepulished);
                result.body = i.body;
            }
            return result;
        }
    }
}
