﻿using System.Linq;
using System.Data.Linq;
using System.Collections.Generic;

using DataAccess.Mapping;
using MVCBlogo.NET.BO;

namespace MVCBlogo.NET.DAL
{
    public static class TagDB
    {
        private static BlogMapDataContext db = new BlogMapDataContext();

        public static int Count(int StartRow, int PageSize)
        {
            return db.tags.Count();
        }
        
        /// <summary>
        /// 根据分类统计出博客的数量
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static int CountByTag(int id)
        {
            return (from tag in db.blog_tags where tag.tag_id == id select tag).Count();
        }

        public static Tag GetItem(int id)
        {
            
            tags t = (from tag in db.tags where tag.id == id select tag).FirstOrDefault();
            return FillRecord(t);
        }

        public static List<Tag> GetList()
        {
            var query = from tag in db.tags orderby tag.tagname ascending select tag;
            List<Tag> result = new List<Tag>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        public static List<Tag> GetList(int StartRow, int PageSize)
        {
            var query = (from tag in db.tags orderby tag.tagname ascending select tag).Skip(StartRow).Take(PageSize);
            List<Tag> result = new List<Tag>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        public static List<Tag> GetList(int parent_id)
        {
            var query = from tag in db.blog_tags where tag.blog_id == parent_id select tag.tags;
            List<Tag> result = new List<Tag>();
            foreach (var t in query)
                result.Add(FillRecord(t));
            return result;
        }

        public static List<Tag> GetListUsedTags(int StartRow, int PageSize)
        {
            var query = (from tag in db.blog_tags orderby tag.tags.tagname  ascending select tag.tags).Distinct().Skip(StartRow).Take(PageSize);
            
            List<Tag> result = new List<Tag>();
            Tag temp = new Tag ();
            foreach (var t in query) 
            { 
                temp = FillRecord(t);
                temp.number = (from tag in db.blog_tags 
                               where (tag.tags ==t)  
                              select tag.tags).Count (); ;
                result.Add(temp);
            }

            result = (from a in result
                     orderby a.number descending
                     select a).ToList();
               
            return result;
        }

        public static long Save(Tag myTag)
        {
            tags t;
            bool found = false;

            if (myTag.id == -1)
            {
                // new record, check if the tagname does not already exist in the database
                tags dupe = (from tag in db.tags where tag.tagname == myTag.tagname select tag).FirstOrDefault();
                if (dupe != null)
                {
                    // duplicate found
                    found = false;
                    t = null;
                }
                else
                {
                    t = new tags();
                    db.tags.InsertOnSubmit(t);
                    found = true;
                }
            }
            else
            {
                // existing record
                t = (from tag in db.tags where tag.id == myTag.id select tag).FirstOrDefault();
                if (t != null)
                {
                    found = true;
                    t.id = myTag.id;
                }
            }

            if (found)
            {

                t.tagname = myTag.tagname;

                try
                {
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
                return t.id;
            }
            else
                return -1;
          
        }

        public static bool Delete(long id)
        {
            tags t = (from tag in db.tags where tag.id == id select tag).FirstOrDefault();
            if (t != null)
            {
                try
                {
                    db.tags.DeleteOnSubmit(t);
                    db.SubmitChanges();
                }
                catch (ChangeConflictException)
                {
                    db.ChangeConflicts.ResolveAll(RefreshMode.OverwriteCurrentValues);
                    db.SubmitChanges();
                }
            }
            return (t!=null);
        }

        private static Tag FillRecord(tags i)
        {
            Tag result = null;
            if (i != null)
            {
                result = new Tag();
                result.id = i.id;
                result.tagname = i.tagname;
               // result.number = i.number; 
            }
            return result;
        }
    }
}
