﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using MVCBlogo.NET.BLL;
using MVCBlogo.NET.BO;
using Utils;

namespace myblog.Controllers
{
    /*
     * 这里继承ApplicationController就是为了能够在实例化BlogController的时候，能够自动执行
     * ApplicationController的构造方法。
     * */
    public class BlogController : ApplicationController   
    {
        //
        // GET: /Blog/

        int pageSize = 3;
        public ViewResult Index(int page)
        {
           //int pageSize = BlogSettings.RSSPageSize;
           if (page * pageSize > BlogEntryManager.Count(0, 1))
           {
               page = page - 1;
           }
           if (page <= 0)
           {
               page = 1;
           }

           ViewData["page"] = page;
           ViewData["Title"] = BlogSettings.BlogTitle; //获取博客网站的名称
           List<BlogEntry> model = new List<BlogEntry>();
           model = BlogEntryManager.GetList((page - 1) * pageSize, pageSize);
           return View(model);

        }

        public ViewResult BlogArticles(int page)
        {
             if( (page-1)*pageSize > BlogEntryManager.CountType(Types.article,0,1))
             {
                 page = page - 1;
             }
             if (page <= 0)
             {
                 page = 1;
             }

             ViewData["page"] = page;
             List<BlogEntry> model = new List<BlogEntry>();
             model = BlogEntryManager.GetListType(Types.article, (page - 1) * pageSize, pageSize).ToList();
             return View(model);
        }
        
        /*  Blog/BlogByMonth?year=2012&month=5*/
        [AcceptVerbs("GET")]
        public ViewResult BlogByMonth(int year, int month, int page)
        {
            if ((page - 1) * pageSize > BlogEntryManager.CountType(Types.article, 0, 1))
            {
                page = page - 1;
            }
            if (page <= 0)
            {
                page = 1;
            }

            ViewData["Page"] = page;
            ViewData["Year"] = year;
            ViewData["Month"] = month;

            List<BlogEntry> model = new List<BlogEntry>();
            model = BlogEntryManager.GetListMonth(year, month, (page - 1) * pageSize, pageSize).ToList();
            return View(model);


        }

        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="id">分类id号</param>
        /// <param name="page">分页的索引</param>
        /// <returns></returns>
        [AcceptVerbs("GET")]
        public ViewResult BlogByTag(int id, int page)
        {
            if ((page - 1) * pageSize > BlogEntryManager.CountType(Types.article, 0, 1))
            {
                page = page - 1;
            }
            if (page <= 0)
            {
                page = 1;
            }

            ViewData["TagName"] = TagManager.GetItem(id).tagname.ToString();//分类的名称
            ViewData["TagId"] = id;
            ViewData["Page"] = page;

            List<BlogEntry> model = new List<BlogEntry>();
            model = BlogEntryManager.GetListTag(id, (page - 1) * pageSize, pageSize).ToList();
            return View(model);

        }

        public ViewResult TagClond()
        {
            int count;
            int min = 0;
            int max = 0;
            int maxStyle = 6;
            int loop = 0;
            List<Tag> userTags = TagManager.GetListUsedTags(0, 1);

            foreach (Tag t in userTags)
            {
                count = TagManager.CountByTag(t.id);//该分类下博客文章的数量
                max = (count > max ? count : max);
                if (loop == 0) //第一次循环的时候做特殊处理
                {
                    min = count;
                }
                else
                {
                    min = (count < min ? count : min);
                }
                loop++;
            }

            string strClound = "";
            foreach (Tag t in userTags)
            {
                count = TagManager.CountByTag(t.id);
                strClound += "<a href =\"BlogByTag.aspx?tag=" + t.id.ToString() + "\" class=\"tag" + GetSizeByCount(count, min, max, maxStyle).ToString() + "\">" + t.tagname + "</a>&nbsp;";
            }
            ViewData["StrClound"] = strClound;
            return View();
        }

        protected int GetSizeByCount(int count,int min,int max,int maxStyle)
        {
            if(max-min==0)
                return Convert.ToInt32(Math.Round((decimal)maxStyle/2));
            else
                return Convert.ToInt32(Math.Round((decimal)(((maxStyle-1)/(max-min)*count)+(1*max-maxStyle*min)/(max-min))));
        }

        public ActionResult BlogEntry(int id)
        {
            MVCBlogo.NET.BO.BlogEntry model = new BlogEntry();
            model = BlogEntryManager.GetItem(id);

            if (model == null)  //指定的ID号的博客不存在
                return RedirectToAction("BlogEntry", new { id = 1 });
            return View(model);
        }

        [AcceptVerbs(HttpVerbs.Post)]
        [ActionName("BlogEntry")]
        public ActionResult AddComment(int id, string commentAuthor, string commentText)
        {
            var comment = new Comment
            {
                blog_id = id,
                author = commentAuthor,
                body = commentText,
                datecreated = DateTime.Now
            };
            try
            {
                if (commentAuthor.Trim().Length == 0)
                    ViewData.ModelState.AddModelError(commentAuthor, "评论者不能为空");
                if (commentText.Trim().Length == 0)
                    ViewData.ModelState.AddModelError(commentText, "评论的内容不能为空");
                if (!ViewData.ModelState.IsValid)
                    throw new InvalidOperationException();

                CommentManager.Save(comment);
                return RedirectToAction("BlogEntry");
            }
            catch (InvalidOperationException ex)
            {
                return View(BlogEntryManager.GetItem(id));
            }
        }

    }
}
