﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Text;

namespace myblog
{
    /// <summary>
    /// 这是对于HtmlHelper类的扩展 
    /// </summary>
    public static class MenuHelper
    {
        public static string Menu(this HtmlHelper helper)
        {
            var sb = new StringBuilder();
            sb.Append("<ul>");
            var topLevelNodes = SiteMap.RootNode.ChildNodes;
            foreach (SiteMapNode node in topLevelNodes)
            {
                if (SiteMap.CurrentNode == node)
                    sb.AppendLine("<li>");
                else
                    sb.AppendLine("<li>");
                sb.AppendFormat("<a href='{0}'>{1}</a>", node.Url, helper.Encode(node.Title));
                sb.AppendLine("</li>");

            }
            sb.Append("</ul>");
            return sb.ToString();
        }
    }
}