﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Admin.Master" Inherits="System.Web.Mvc.ViewPage<MVCBlogo.NET.BO.BlogEntry>" %>
<%@ Import Namespace="MVCBlogo.NET.BO" %>
<asp:Content ID="Content1" ContentPlaceHolderID="ContentPlaceHolderPage" runat="server">
 <script src="../../Scripts/tiny_mce/tiny_mce.js" type="text/javascript"></script>
 <script type="text/javascript">
     tinyMCE.init({
         // General options 
         mode: "textareas",
         theme: "advanced",
         plugins: "autolink,lists,pagebreak,style,layer,table,save,advhr,advimage,advlink,emotions,iespell,inlinepopups,insertdatetime,preview,media,searchreplace,print,contextmenu,paste,directionality,fullscreen,noneditable,visualchars,nonbreaking,xhtmlxtras,template,wordcount,advlist,autosave,visualblocks",

         // Theme options
         theme_advanced_buttons1: "save,newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
         theme_advanced_buttons2: "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,|,insertdate,inserttime,preview,|,forecolor,backcolor",
         theme_advanced_buttons3: "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,emotions,iespell,media,advhr,|,print,|,ltr,rtl,|,fullscreen",
         theme_advanced_buttons4: "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,visualchars,nonbreaking,template,pagebreak,restoredraft,visualblocks",
         theme_advanced_toolbar_location: "top",
         theme_advanced_toolbar_align: "left",
         theme_advanced_statusbar_location: "bottom",
         theme_advanced_resizing: true,

         // Example content CSS (should be your site CSS)
         content_css: "css/content.css",

         // Drop lists for link/image/media/template dialogs
         template_external_list_url: "lists/template_list.js",
         external_link_list_url: "lists/link_list.js",
         external_image_list_url: "/Admin/ImageList",
         media_external_list_url: "lists/media_list.js",

         // Style formats
         style_formats: [
			{ title: 'Bold text', inline: 'b' },
			{ title: 'Red text', inline: 'span', styles: { color: '#ff0000'} },
			{ title: 'Red header', block: 'h1', styles: { color: '#ff0000'} },
			{ title: 'Example 1', inline: 'span', classes: 'example1' },
			{ title: 'Example 2', inline: 'span', classes: 'example2' },
			{ title: 'Table styles' },
			{ title: 'Table row 1', selector: 'tr', classes: 'tablerow1' }
		]
        

     });        
         
         
   </script> 

    <h3>新建随笔文章</h3>

    <%= Html.ValidationSummary("新建随笔、文章失败！请修改错误后重试。") %>

    <% using (Html.BeginForm("AdminBlogCreate","Admin",FormMethod.Post  )) {%>
    <div>
        <fieldset>
                     
            <p>
                <label for="username">作者：</label>
                <%= Html.DropDownList ("username")%>
                <%= Html.ValidationMessage("username", "*")%>
            </p>
            <p>
                <label for="title">标题：</label>
                <%= Html.TextBox("title",null,  new { size=72})%>
                <%= Html.ValidationMessage("title", "*") %>
            </p>
            <p>
                <label for="description">描述：</label>
                <%= Html.TextBox("description")%>
                <%= Html.ValidationMessage("description", "*")%>
            </p>
            <p>
                <label for="title">分类：</label>
                <!--从后台取出基础的分类数据进行加载-->
                <% foreach (var tag in (List<Tag>)ViewData["tag"])
                   {
                 %>
                     <%=Html.CheckBox("TagCheckBox",false,new{id=tag.tagname}) %>
                     <label for="<%=tag.tagname %>"><%=tag.tagname %></label>
                     <br /><span class="style1"><label for="title">分类：</label></span>
                 <%
                   } %>
            </p>
            <p>
                <label for="title">类型：</label>
                
                <%= Html.RadioButton("type", "article", true, new  { id="type1" })%>
                  <label for="type1" >文章</label>               
                  <%= Html.RadioButton("type", "blogentry", false, new { id = "type2" })%>
                     <label for="type2" >随笔</label>  

            </p>
            <p>         
                <label for="title">允许评论：</label>
                
                  <%  =Html.CheckBox("CommentCheckBox") %>                                   
               </p>
            <p>
                <label for="title">私有：</label>
                  <%  =Html.CheckBox("PrivateCheckBox") %>                                   
            </p>
             <p>           
                 <label for="title">内容：</label>
                   
                   <% =Html.TextArea ("body",null,40,20,null) %>
               
            </p>
            <p>
                <input type="submit" value="新建" class="button"  />
            </p>        
        </fieldset>
    </div>
    <% } %>
</asp:Content>
